/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.schema;

import com.datastax.bdp.graph.api.model.EdgeIndex;
import com.datastax.bdp.graph.api.model.EdgeLabel;
import com.datastax.bdp.graph.api.model.IdPropertyKey;
import com.datastax.bdp.graph.api.model.IndexedPropertyKey;
import com.datastax.bdp.graph.api.model.PropertyIndex;
import com.datastax.bdp.graph.api.model.PropertyKey;
import com.datastax.bdp.graph.api.model.Schema;
import com.datastax.bdp.graph.api.model.VertexIndex;
import com.datastax.bdp.graph.api.model.VertexLabel;
import com.datastax.bdp.graph.api.schema.SchemaImpl;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class VertexLabelImpl {
    private final String vertexLabelName;
    private final Schema schema;
    private VertexIndex.Builder vertexIndexBuilder;
    private VertexLabel.Builder vertexLabelBuilder;
    private String indexName;
    private EdgeIndex.Builder edgeIndexBuilder;
    private List<String> propertyKeys = new ArrayList<String>();
    private List<String> edgeLabels = new ArrayList<String>();
    private PropertyIndex.Builder propertyIndexBuilder;
    private boolean cache = false;
    private ElementType cacheType = null;
    private Duration ttl = null;
    private String propertyKey;

    VertexLabelImpl(Schema schema, String name) {
        this.schema = schema;
        this.vertexLabelName = name;
        this.vertexLabelBuilder = schema.buildVertexLabel(this.vertexLabelName);
    }

    boolean exists() {
        return this.schema.vertexLabel(this.vertexLabelName) != null;
    }

    void index(String name) {
        this.indexName = name;
    }

    void materialized() {
        this.vertexIndexBuilder = this.getVertexLabel().buildVertexIndex(this.indexName).materialized();
    }

    void secondary() {
        this.vertexIndexBuilder = this.getVertexLabel().buildVertexIndex(this.indexName).secondary();
    }

    void search() {
        this.vertexIndexBuilder = this.getVertexLabel().buildVertexIndex(this.indexName).search();
    }

    void by(String propertyKey) {
        this.propertyKey = propertyKey;
        if (this.vertexIndexBuilder != null) {
            this.vertexIndexBuilder = this.vertexIndexBuilder.byPropertyKey(propertyKey);
        } else if (this.propertyIndexBuilder != null) {
            this.propertyIndexBuilder = this.propertyIndexBuilder.byMetaPropertyKey(propertyKey);
        } else if (this.edgeIndexBuilder != null) {
            this.edgeIndexBuilder = this.edgeIndexBuilder.byPropertyKey(propertyKey);
        } else {
            throw new AssertionError((Object)"Unplanned invocation");
        }
    }

    void asText() {
        this.vertexIndexBuilder = this.vertexIndexBuilder.byPropertyKeyAsText(this.propertyKey, VertexIndex.IndexOption.Text.FULLTEXT);
    }

    void asString() {
        this.vertexIndexBuilder = this.vertexIndexBuilder.byPropertyKeyAsText(this.propertyKey, VertexIndex.IndexOption.Text.STRING);
    }

    void asStringAndText() {
        this.vertexIndexBuilder = this.vertexIndexBuilder.byPropertyKeyAsStringAndText(this.propertyKey);
    }

    void withError(double maxDistErr, double distErrPct) {
        this.vertexIndexBuilder = this.vertexIndexBuilder.byPropertyKeyWithError(this.propertyKey, maxDistErr, distErrPct);
    }

    void outE(String label) {
        if (this.indexName != null) {
            this.edgeIndexBuilder = this.getVertexLabel().buildEdgeIndex(this.indexName, label).out();
        }
    }

    void inE(String label) {
        if (this.indexName != null) {
            this.edgeIndexBuilder = this.getVertexLabel().buildEdgeIndex(this.indexName, label).in();
        }
    }

    void cache() {
        this.cache = true;
    }

    void bothE(String label) {
        if (this.cache) {
            this.cacheType = ElementType.EDGE;
            this.edgeLabels.add(label);
        } else {
            this.edgeIndexBuilder = this.getVertexLabel().buildEdgeIndex(this.indexName, label).both();
        }
    }

    void bothE(String ... labels) {
        if (labels != null && labels.length == 1) {
            this.bothE(labels[0]);
        } else if (labels != null && labels.length > 0) {
            this.edgeLabels.addAll(Arrays.asList(labels));
        }
        if (!this.cache) {
            throw new IllegalArgumentException("Need to specify exactly one edge label when building an edge index");
        }
        this.cacheType = ElementType.EDGE;
    }

    void properties(String first, String ... properties) {
        this.propertyKeys.add(first);
        if (properties != null && properties.length > 0) {
            this.propertyKeys.addAll(Arrays.asList(properties));
        }
        if (this.cache) {
            throw new IllegalArgumentException("Can only cache ALL properties - not a subset");
        }
    }

    void properties() {
        if (this.cache) {
            this.cacheType = ElementType.PROPERTY;
        }
    }

    void property(String propertyKey) {
        this.propertyIndexBuilder = this.getVertexLabel().buildPropertyIndex(this.indexName, propertyKey);
    }

    void ttl(int timeToLiveInSeconds) {
        Preconditions.checkArgument((timeToLiveInSeconds > 0 ? 1 : 0) != 0, (String)"Time-to-live is specified in seconds and must be a positive number. Given: %s", (int)timeToLiveInSeconds);
        this.ttl = Duration.ofSeconds(timeToLiveInSeconds);
        this.vertexLabelBuilder = this.vertexLabelBuilder.ttl(this.ttl);
    }

    void ifNotExists() {
        this.vertexLabelBuilder = this.vertexLabelBuilder.ifNotExists();
        if (this.vertexIndexBuilder != null) {
            this.vertexIndexBuilder = this.vertexIndexBuilder.ifNotExists();
        }
        if (this.propertyIndexBuilder != null) {
            this.propertyIndexBuilder = this.propertyIndexBuilder.ifNotExists();
        }
        if (this.edgeIndexBuilder != null) {
            this.edgeIndexBuilder = this.edgeIndexBuilder.ifNotExists();
        }
    }

    void partitionKey(String first, String ... properties) {
        this.vertexLabelBuilder = this.vertexLabelBuilder.partitionId(first);
        for (String pk : properties) {
            this.vertexLabelBuilder = this.vertexLabelBuilder.partitionId(pk);
        }
    }

    void clusteringKey(String first, String ... properties) {
        this.vertexLabelBuilder = this.vertexLabelBuilder.clusteringId(first);
        for (String pk : properties) {
            this.vertexLabelBuilder = this.vertexLabelBuilder.clusteringId(pk);
        }
    }

    void create() {
        this.propertyKeys.forEach(pk -> this.vertexLabelBuilder.addPropertyKeys((String)pk));
        this.vertexLabelBuilder.add();
    }

    void add() {
        this.propertyKeys.forEach(it -> this.getVertexLabel().addPropertyKey((String)it));
        if (this.vertexIndexBuilder != null) {
            this.vertexIndexBuilder.add();
        }
        if (this.propertyIndexBuilder != null) {
            this.propertyIndexBuilder.add();
        }
        if (this.edgeIndexBuilder != null) {
            this.edgeIndexBuilder.add();
        }
        if (this.cacheType != null) {
            if (this.cacheType == ElementType.EDGE) {
                this.getVertexLabel().setEdgeCacheTime(this.ttl, this.edgeLabels.toArray(new String[this.edgeLabels.size()]));
            } else if (this.cacheType == ElementType.PROPERTY) {
                this.getVertexLabel().setPropertyCacheTime(this.ttl);
            } else {
                throw new AssertionError((Object)("Invalid cache type: " + (Object)((Object)this.cacheType)));
            }
        }
    }

    String remove() {
        this.drop();
        if (null != this.indexName || null != this.cacheType) {
            return "'remove()' is deprecated and will be removed in a future release. Please use 'drop()' instead.";
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void drop() {
        if (this.indexName != null) {
            PropertyIndex propertyIndex;
            EdgeIndex edgeIndex;
            VertexIndex vertexIndex = this.getVertexLabel().vertexIndex(this.indexName);
            if (vertexIndex != null) {
                if (this.propertyKeys.isEmpty()) {
                    vertexIndex.drop();
                } else {
                    this.propertyKeys.forEach(it -> vertexIndex.dropPropertyKey((String)it));
                }
            }
            if ((edgeIndex = this.getVertexLabel().edgeIndex(this.indexName)) != null) {
                edgeIndex.drop();
            }
            if ((propertyIndex = this.getVertexLabel().propertyIndex(this.indexName)) == null) return;
            propertyIndex.drop();
            return;
        } else if (this.cacheType != null) {
            if (this.cacheType == ElementType.EDGE) {
                this.getVertexLabel().setEdgeCacheTime(Duration.ZERO, this.edgeLabels.toArray(new String[this.edgeLabels.size()]));
                return;
            } else {
                if (this.cacheType != ElementType.PROPERTY) throw new AssertionError((Object)("Invalid cache type: " + (Object)((Object)this.cacheType)));
                if (!this.propertyKeys.isEmpty()) {
                    throw new IllegalArgumentException("Can only cache ALL properties - not a subset");
                }
                this.getVertexLabel().setPropertyCacheTime(Duration.ZERO);
            }
            return;
        } else if (!this.propertyKeys.isEmpty()) {
            for (String key : this.propertyKeys) {
                this.getVertexLabel().dropPropertyKey(key);
            }
            return;
        } else {
            this.getVertexLabel().drop();
        }
    }

    String describe() {
        VertexLabel vl = this.getVertexLabel();
        StringBuilder s = new StringBuilder();
        s.append(this.vertexLabelDescription(vl));
        Set<? extends IdPropertyKey> idKeys = vl.idPropertyKeys();
        if (!idKeys.isEmpty() && !vl.hasStandardId()) {
            s.append(".partitionKey(");
            s.append(SchemaImpl.toCommaSeparatedList(idKeys.stream().filter(it -> it.getType() == IdPropertyKey.Type.Partition)));
            s.append(")");
            if (idKeys.stream().filter(it -> it.getType() == IdPropertyKey.Type.Clustering).count() > 0L) {
                s.append(".clusteringKey(");
                s.append(SchemaImpl.toCommaSeparatedList(idKeys.stream().filter(it -> it.getType() == IdPropertyKey.Type.Clustering)));
                s.append(")");
            }
        }
        LinkedHashSet<? extends PropertyKey> remainingProperties = new LinkedHashSet<PropertyKey>(vl.propertyKeys());
        remainingProperties.removeAll(idKeys);
        if (!remainingProperties.isEmpty()) {
            s.append(".properties(");
            s.append(SchemaImpl.toCommaSeparatedList(remainingProperties.stream()));
            s.append(")");
        }
        if (vl.ttl().isPresent()) {
            s.append(".ttl(").append(vl.ttl().get().getSeconds()).append(")");
        }
        s.append(".create()");
        vl.vertexIndices().forEach(it -> {
            s.append("\n" + this.vertexLabelDescription(vl));
            s.append(".index(" + SchemaImpl.quote(it) + ")." + it.getType().name().toLowerCase() + "()");
            s.append(it.propertyKeys().stream().map(p -> ".by(" + SchemaImpl.quote(p) + ")" + this.searchParamsDescription((VertexIndex)it, (IndexedPropertyKey)p)).collect(Collectors.joining()));
            s.append(".add()");
        });
        vl.edgeIndices().forEach(it -> {
            s.append("\n" + this.vertexLabelDescription(vl));
            s.append(".index(" + SchemaImpl.quote(it) + ")." + it.direction().name().toLowerCase() + "E(" + SchemaImpl.quote(it.edgeLabel()) + ")");
            s.append(it.propertyKeys().stream().map(p -> ".by(" + SchemaImpl.quote(p) + ")").collect(Collectors.joining()));
            s.append(".add()");
        });
        vl.propertyIndices().forEach(it -> {
            s.append("\n" + this.vertexLabelDescription(vl));
            s.append(".index(" + SchemaImpl.quote(it) + ").property(" + SchemaImpl.quote(it.propertyKey()) + ")");
            s.append(it.propertyKeys().stream().map(p -> ".by(" + SchemaImpl.quote(p) + ")").collect(Collectors.joining()));
            s.append(".add()");
        });
        vl.cacheConfigs().forEach(it -> {
            s.append("\n" + this.vertexLabelDescription(vl));
            s.append(".cache()");
            if (it.isPropertyCache()) {
                s.append(".properties()");
            } else {
                EdgeLabel el = it.edgeLabel();
                s.append(".bothE(");
                if (el != null) {
                    s.append(SchemaImpl.quote(el));
                }
                s.append(")");
            }
            s.append(".ttl(").append(it.cacheTime().getSeconds()).append(").add()");
        });
        return s.toString();
    }

    private String searchParamsDescription(VertexIndex it, IndexedPropertyKey p) {
        if (p.getIndexOption().isDescriptionSuppressed()) {
            return "";
        }
        return p.getIndexOption().describe();
    }

    private String vertexLabelDescription(VertexLabel vertexLabel) {
        return "schema.vertexLabel(" + SchemaImpl.quote(vertexLabel) + ")";
    }

    private VertexLabel getVertexLabel() {
        VertexLabel vertexLabel = this.schema.vertexLabel(this.vertexLabelName);
        if (vertexLabel == null) {
            throw new IllegalArgumentException("Vertex label does not exist: " + this.vertexLabelName);
        }
        return vertexLabel;
    }

    private static enum ElementType {
        PROPERTY,
        EDGE;

    }
}

