/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.model;

import java.util.Set;

import com.datastax.bdp.graph.api.Identified;
import com.datastax.bdp.graph.api.Named;

/**
 * Property indexes allow quick retrieval of vertex properties with certain meta-properties associated with a
 * particular vertex by gremlin queries.
 *
 */
public interface PropertyIndex extends Named, Identified
{

    /**
     *
     * @return The {@link VertexLabel} that this index is on.
     */
    VertexLabel vertexLabel();

    /**
     * @return The {@link PropertyKey}s by which the vertex properties of this index are indexed
     */
    PropertyKey propertyKey();

    /**
     * @return The meta-{@link PropertyKey}s by which the edges of this index are indexed
     */
    Set<? extends IndexedPropertyKey> propertyKeys();

    /**
     * Drops this index.
     */
    void drop();


    interface Builder {

        /**
         * Index vertex properties by their value.
         * @return This builder.
         */
        //TODO https://datastax.jira.com/browse/DSP-6154
        //Builder byValue();


        /**
         * Indexes vertex properties by the meta-property of the given property key.
         *
         * @param metaPropertyKey The meta-property key to be indexed.
         * @return This builder.
         */
        Builder byMetaPropertyKey(String metaPropertyKey);

        /**
         * @return if the property index already exists then just return it.
         */
        Builder ifNotExists();

        /**
         * @return Create and add this property index to the schema.
         */
        PropertyIndex add();

    }

}
