/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.schema;

import com.datastax.bdp.graph.api.model.config.GraphConfig;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationImpl {
    private final GraphConfig config;
    private String configOption;

    ConfigurationImpl(GraphConfig config) {
        this.config = config;
    }

    String describe() {
        StringBuilder s = new StringBuilder();
        int pos = 0;
        for (Map.Entry entry : this.config) {
            if (pos > 0) {
                s.append("\n");
            }
            s.append((String)entry.getKey()).append(": ").append(String.valueOf(entry.getValue()));
            ++pos;
        }
        return s.toString();
    }

    void option(String configOption) {
        if (StringUtils.isBlank((CharSequence)configOption)) {
            throw new IllegalArgumentException("Invalid config option");
        }
        this.configOption = configOption;
    }

    void set(Object value) {
        this.config.set(this.configOption, value);
    }

    void unset() {
        this.config.unset(this.configOption);
    }

    Object get() {
        return this.config.get(this.configOption);
    }

    boolean exists() {
        return this.config.contains(this.configOption);
    }
}

