/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.schema;

import com.datastax.bdp.graph.api.model.Adjacency;
import com.datastax.bdp.graph.api.model.Cardinality;
import com.datastax.bdp.graph.api.model.EdgeLabel;
import com.datastax.bdp.graph.api.model.Schema;
import com.datastax.bdp.graph.api.model.VertexLabel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.javatuples.Pair;

public class EdgeLabelImpl {
    private final Schema schema;
    private final String name;
    private EdgeLabel.Builder builder;
    private final List<String> propertyKeys = new ArrayList<String>();
    private final List<Pair<String, String>> connections = new ArrayList<Pair<String, String>>();

    EdgeLabelImpl(Schema schema, String name) {
        this.schema = schema;
        this.name = name;
        this.builder = schema.buildEdgeLabel(name);
    }

    void connection(String outV, String inV) {
        this.connections.add((Pair<String, String>)Pair.with((Object)outV, (Object)inV));
    }

    void properties(String first, String ... properties) {
        this.propertyKeys.add(first);
        this.propertyKeys.addAll(Arrays.asList(properties));
    }

    void single() {
        this.builder = this.builder.single();
    }

    void multiple() {
        this.builder = this.builder.multiple();
    }

    void ifNotExists() {
        this.builder = this.builder.ifNotExists();
    }

    void ttl(int timeToLiveInSeconds) {
        this.builder = this.builder.ttl(Duration.ofSeconds(timeToLiveInSeconds));
    }

    String describe() {
        String result = this.describeEdgeLabel();
        String connectStr = this.describeConnections();
        if (StringUtils.isNotBlank((CharSequence)connectStr)) {
            result = result + "\n" + connectStr;
        }
        return result;
    }

    String describeEdgeLabel() {
        EdgeLabel edgeLabel = this.getEdgeLabel();
        StringBuilder s = new StringBuilder();
        s.append("schema.edgeLabel(").append("\"").append(edgeLabel.name()).append("\"").append(")");
        if (edgeLabel.cardinality() == Cardinality.Single) {
            s.append(".single()");
        } else {
            s.append(".multiple()");
        }
        if (!edgeLabel.propertyKeys().isEmpty()) {
            s.append(".properties(");
            s.append(edgeLabel.propertyKeys().stream().map(it -> "\"" + it.name() + "\"").collect(Collectors.joining(", ")));
            s.append(")");
        }
        if (edgeLabel.ttl().isPresent()) {
            s.append(".ttl(").append(edgeLabel.ttl().get().getSeconds()).append(")");
        }
        s.append(".create()");
        return s.toString();
    }

    String describeConnections() {
        EdgeLabel edgeLabel = this.getEdgeLabel();
        List<Adjacency> adjacencies = this.getAdjacencies();
        if (!adjacencies.isEmpty()) {
            StringBuilder s = new StringBuilder();
            s.append("schema.edgeLabel(").append("\"").append(edgeLabel.name()).append("\"").append(")");
            adjacencies.forEach(adj -> s.append(".connection(").append("\"").append(adj.vertexLabel().name()).append("\"").append(", ").append("\"").append(adj.otherLabel().name()).append("\"").append(")"));
            s.append(".add()");
            return s.toString();
        }
        return "";
    }

    void add() {
        EdgeLabel edgeLabel = this.getEdgeLabel();
        this.propertyKeys.forEach(it -> edgeLabel.addPropertyKey((String)it));
        this.registerConnections();
    }

    void create() {
        this.propertyKeys.forEach(pKey -> this.builder.addPropertyKeys((String)pKey));
        this.builder.add();
        this.registerConnections();
    }

    boolean exists() {
        return this.schema.edgeLabel(this.name) != null;
    }

    private void registerConnections() {
        this.connections.forEach(it -> {
            VertexLabel outV = this.schema.vertexLabel((String)it.getValue0());
            if (outV == null) {
                throw new IllegalArgumentException("Vertex label does not exist: " + (String)it.getValue0());
            }
            outV.addAdjacency(this.name, Direction.OUT, (String)it.getValue1());
        });
    }

    private EdgeLabel getEdgeLabel() {
        EdgeLabel edgeLabel = this.schema.edgeLabel(this.name);
        if (edgeLabel == null) {
            throw new IllegalArgumentException("Edge label does not exist: " + this.name);
        }
        return edgeLabel;
    }

    private List<Adjacency> getAdjacencies() {
        EdgeLabel edgeLabel = this.getEdgeLabel();
        return this.schema.vertexLabels().stream().flatMap(it -> it.adjacencies().stream().filter(a -> a.direction() == Direction.OUT && a.edgeLabel().equals(edgeLabel))).collect(Collectors.toList());
    }

    void drop() {
        if (!this.propertyKeys.isEmpty()) {
            for (String propertyKey : this.propertyKeys) {
                this.getEdgeLabel().dropPropertyKey(propertyKey);
            }
        } else {
            this.getEdgeLabel().drop();
        }
    }
}

