/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.schema;

import com.datastax.bdp.graph.api.model.BasicValueType;
import com.datastax.bdp.graph.api.model.Cardinality;
import com.datastax.bdp.graph.api.model.PropertyKey;
import com.datastax.bdp.graph.api.model.Schema;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class PropertyKeyImpl {
    private final Schema schema;
    private final String name;
    private PropertyKey.Builder builder = null;
    private List<String> propertyKeys = new ArrayList<String>();

    PropertyKeyImpl(Schema schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    void Boolean() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Boolean);
    }

    void Int() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Int);
    }

    void Smallint() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Smallint);
    }

    void Bigint() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Bigint);
    }

    void Float() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Float);
    }

    void Double() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Double);
    }

    void Decimal() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Decimal);
    }

    void Varint() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Varint);
    }

    void Timestamp() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Timestamp);
    }

    void Date() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Date);
    }

    void Time() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Time);
    }

    void Duration() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Duration);
    }

    void Text() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Text);
    }

    void Uuid() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Uuid);
    }

    void Inet() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Inet);
    }

    void Blob() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Blob);
    }

    void Point() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Point);
    }

    void Linestring() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Linestring);
    }

    void Polygon() {
        this.builder = this.schema.buildPropertyKey(this.name, BasicValueType.Polygon);
    }

    void multiple() {
        this.builder = this.builder.multiple();
    }

    void single() {
        this.builder = this.builder.single();
    }

    void properties(String first, String ... properties) {
        this.propertyKeys.add(first);
        if (properties != null) {
            this.propertyKeys.addAll(Arrays.asList(properties));
        }
    }

    void ifNotExists() {
        this.builder = this.builder.ifNotExists();
    }

    void ttl(int timeToLiveInSeconds) {
        this.builder = this.builder.ttl(Duration.ofSeconds(timeToLiveInSeconds));
    }

    void create() {
        this.propertyKeys.forEach(it -> this.builder.addPropertyKeys((String)it));
        this.builder.add();
    }

    void add() {
        this.propertyKeys.forEach(it -> this.getPropertyKey().addPropertyKey((String)it));
    }

    void drop() {
        if (!this.propertyKeys.isEmpty()) {
            this.propertyKeys.forEach(it -> this.getPropertyKey().dropPropertyKey((String)it));
        } else {
            this.getPropertyKey().drop();
        }
    }

    String describe() {
        return this.describe(true);
    }

    private String describe(boolean metaProperties) {
        PropertyKey propertyKey = this.getPropertyKey();
        StringBuilder s = new StringBuilder();
        s.append("schema.propertyKey(").append("\"").append(propertyKey.name()).append("\"").append(")");
        s.append("." + propertyKey.dataType().toString() + "()");
        List<PropertyKey.Validator<?>> validators = propertyKey.validators();
        for (PropertyKey.Validator<?> validator : validators) {
            s.append(validator.describe());
        }
        if (propertyKey.cardinality() == Cardinality.Single) {
            s.append(".single()");
        } else {
            s.append(".multiple()");
        }
        if (!propertyKey.propertyKeys().isEmpty() && metaProperties) {
            s.append(".properties(");
            s.append(propertyKey.propertyKeys().stream().map(it -> "\"" + it.name() + "\"").collect(Collectors.joining(", ")));
            s.append(")");
        }
        if (propertyKey.ttl().isPresent()) {
            s.append(".ttl(").append(propertyKey.ttl().get().getSeconds()).append(")");
        }
        s.append(".create()");
        return s.toString();
    }

    public String describeCoreDefinition() {
        return this.describe(false);
    }

    public String describeMetaProperties() {
        PropertyKey propertyKey = this.getPropertyKey();
        if (!propertyKey.propertyKeys().isEmpty()) {
            StringBuilder s = new StringBuilder();
            s.append("schema.propertyKey(").append("\"").append(propertyKey.name()).append("\"").append(")");
            if (!propertyKey.propertyKeys().isEmpty()) {
                s.append(".properties(");
                s.append(propertyKey.propertyKeys().stream().map(it -> "\"" + it.name() + "\"").collect(Collectors.joining(", ")));
                s.append(")");
            }
            s.append(".add()");
            return s.toString();
        }
        return null;
    }

    boolean exists() {
        return this.schema.propertyKey(this.name) != null;
    }

    private PropertyKey getPropertyKey() {
        PropertyKey propertyKey = this.schema.propertyKey(this.name);
        if (propertyKey == null) {
            throw new IllegalArgumentException("Property key does not exist: " + this.name);
        }
        return propertyKey;
    }

    void withGeoBounds() {
        this.builder.geoBounds();
    }

    void withBounds(double minX, double minY, double maxX, double maxY) {
        this.builder.bounds(minX, minY, maxX, maxY);
    }
}

