/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.model.config;

/**
 * User-facing configuration API.
 *
 * Contains all of the configuration options for a {@link com.datastax.bdp.graph.api.DseGraph} instance nested
 * structure of {@link GraphConfigspace}s. A {@link GraphConfig} is also the root {@link GraphConfigspace}.
 *
 * @author Matthias Broecheler (me@matthiasb.com)
 */
public interface GraphConfig extends GraphConfigspace
{

    @Override
    GraphConfig set(String configOption, Object value);

    @Override
    default GraphConfig unset(String configOption) {
        return set(configOption,null);
    }

}
