/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.system;

import com.datastax.bdp.graph.api.model.system.GraphBuilder;
import com.datastax.bdp.graph.api.model.system.GraphSystem;
import com.datastax.bdp.graph.api.schema.SchemaImpl;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class GraphBuilderImpl {
    public static final String REPLICATION_CONFIG = "replication_config";
    public static final String SYSTEM_REPLICATION_CONFIG = "system_replication_config";
    private final GraphSystem system;
    private final String name;
    private boolean ifExists;
    private GraphBuilder builder = null;
    private String configOption = null;

    public GraphBuilderImpl(GraphSystem system, String name) {
        this.system = system;
        this.name = name;
    }

    public void drop() {
        if (!this.ifExists || this.system.graphExists(this.name)) {
            this.system.dropGraph(this.name);
        }
    }

    public void truncate() {
        if (!this.ifExists || this.system.graphExists(this.name)) {
            this.system.truncateGraph(this.name);
        }
    }

    public String describe() {
        return GraphBuilderImpl.describe(this.name);
    }

    static String describe(String graphName) {
        return "system.graph(" + SchemaImpl.quote(graphName) + ").create()";
    }

    public boolean exists() {
        return this.system.graphExists(this.name);
    }

    private final GraphBuilder builder() {
        if (this.builder == null) {
            this.builder = this.system.createGraph(this.name);
        }
        return this.builder;
    }

    public void option(String configOption) {
        if (StringUtils.isBlank((CharSequence)configOption)) {
            throw new IllegalArgumentException("Invalid config option");
        }
        this.configOption = configOption;
    }

    public void set(Object value) {
        Preconditions.checkArgument((this.configOption != null ? 1 : 0) != 0, (Object)"Invalid invocation - need to specify config option first");
        this.builder().set(this.configOption, value);
        this.configOption = null;
    }

    public void ifExists() {
        this.ifExists = true;
    }

    public void ifNotExists() {
        this.builder().ifNotExists();
    }

    public void create() {
        this.builder().build();
    }

    public void replication(String replication) {
        this.builder().set(REPLICATION_CONFIG, replication);
    }

    public void systemReplication(String replication) {
        this.builder().set(SYSTEM_REPLICATION_CONFIG, replication);
    }
}

