/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api;

import com.datastax.bdp.graph.api.id.DsegId;

/**
 * Represents an entity that can be uniquely identified by a {@link DsegId} id.
 */
public interface Identified {

    /**
     * Unique identifier for this entity.
     *
     * @return Unique id for this entity
     */
    public DsegId id();

}
