/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.model;

import org.apache.tinkerpop.gremlin.structure.VertexProperty;

/**
 * Represents single or multiple cardinality.
 * Single cardinality means that only one of "something" is allowed whereas multiple does not have such a restriction.
 * What "something" is depends on the context.
 *
 */
public enum Cardinality {
    /**
     * More than one is allowed.
     */
    Multiple(VertexProperty.Cardinality.list),
    /**
     * Only one is allowed.
     */
    Single(VertexProperty.Cardinality.single),

    /**
     * The default cardinality as configured in the config file.
     */
    Default(null);

    private VertexProperty.Cardinality cardinality;

    Cardinality(VertexProperty.Cardinality cardinality)
    {
        this.cardinality = cardinality;
    }

    /**
     * Converts to TinkerPop's cardinality enum
     *
     * @return The tinkerpop cardinality
     */
    public VertexProperty.Cardinality vertexPropertyCardinality()
    {
        return cardinality;
    }

}
