/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.spark;

import com.datastax.bdp.cassandra.auth.InProcessAuthProvider;
import com.datastax.bdp.server.SystemInfo;
import com.datastax.bdp.spark.DseCassandraConnectionFactory$;
import com.datastax.bdp.util.Addresses;
import com.datastax.bdp.util.DseUtil;
import com.datastax.bdp.util.ExtraJavaConversions$;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.ThreadingOptions;
import com.datastax.driver.core.policies.HostFilterPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.dse.DseCluster;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy;
import com.datastax.spark.connector.cql.Scanner;
import com.datastax.spark.connector.rdd.ReadConf;
import com.google.common.base.Predicate;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;
import org.apache.cassandra.config.DatabaseDescriptor;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class InProcessConnectionFactory$
implements CassandraConnectionFactory,
StrictLogging {
    public static final InProcessConnectionFactory$ MODULE$;
    private final Logger logger;

    static {
        new InProcessConnectionFactory$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Set<String> properties() {
        return CassandraConnectionFactory.class.properties((CassandraConnectionFactory)this);
    }

    public Scanner getScanner(ReadConf readConf, CassandraConnectorConf connConf, IndexedSeq<String> columnNames) {
        return CassandraConnectionFactory.class.getScanner((CassandraConnectionFactory)this, (ReadConf)readConf, (CassandraConnectorConf)connConf, columnNames);
    }

    public Cluster createCluster(CassandraConnectorConf conf) {
        Configuration defConf = DseCassandraConnectionFactory$.MODULE$.getClusterBuilder(conf).getConfiguration();
        DseCluster.Builder clusterBuilder = DseCluster.builder();
        int port = BoxesRunTime.unboxToInt((Object)DseCassandraConnectionFactory$.MODULE$.sslOptions(conf).map((Function1)new Serializable(clusterBuilder){
            public static final long serialVersionUID = 0L;
            private final DseCluster.Builder clusterBuilder$1;

            public final int apply(SSLOptions opts) {
                this.clusterBuilder$1.withSSL(opts);
                return DatabaseDescriptor.getNativeTransportPortSSL();
            }
            {
                this.clusterBuilder$1 = clusterBuilder$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return DatabaseDescriptor.getNativeTransportPort();
            }
        }));
        InetSocketAddress contactPoint = new InetSocketAddress(Addresses.Client.getBroadcastAddress(), port);
        LocalNodeFirstLoadBalancingPolicy baseLBP = new LocalNodeFirstLoadBalancingPolicy((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{contactPoint.getAddress()})), (Option)new Some((Object)DseUtil.getDatacenter()), false);
        UUID thisHostID = SystemInfo.getHostId();
        HostFilterPolicy thisHostOnlyPolicy = new HostFilterPolicy((LoadBalancingPolicy)baseLBP, (Predicate)ExtraJavaConversions$.MODULE$.toJavaPredicate((Function1)new Serializable(thisHostID){
            public static final long serialVersionUID = 0L;
            private final UUID thisHostID$1;

            public final boolean apply(Host x$1) {
                UUID uUID = x$1.getHostId();
                UUID uUID2 = this.thisHostID$1;
                return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
            }
            {
                this.thisHostID$1 = thisHostID$1;
            }
        }));
        clusterBuilder.withLoadBalancingPolicy((LoadBalancingPolicy)thisHostOnlyPolicy).withAuthProvider((AuthProvider)new InProcessAuthProvider()).withRetryPolicy(defConf.getPolicies().getRetryPolicy()).withReconnectionPolicy(defConf.getPolicies().getReconnectionPolicy()).withSocketOptions(defConf.getSocketOptions()).withCompression(defConf.getProtocolOptions().getCompression()).withQueryOptions(defConf.getQueryOptions()).withoutGeospatialCodecs().addContactPointsWithPorts(new InetSocketAddress[]{contactPoint}).withoutJMXReporting().withoutMetrics().withThreadingOptions((ThreadingOptions)new CassandraConnectionFactory.DaemonThreadingOptions());
        return clusterBuilder.build();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private InProcessConnectionFactory$() {
        MODULE$ = this;
        CassandraConnectionFactory.class.$init$((CassandraConnectionFactory)this);
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

