/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;

@Deprecated
public class ProducerConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ProducerConfigurationData conf = new ProducerConfigurationData();

    public String getProducerName() {
        return this.conf.getProducerName();
    }

    public void setProducerName(String producerName) {
        this.conf.setProducerName(producerName);
    }

    public long getSendTimeoutMs() {
        return this.conf.getSendTimeoutMs();
    }

    public ProducerConfiguration setSendTimeout(int sendTimeout, TimeUnit unit) {
        this.conf.setSendTimeoutMs(sendTimeout, unit);
        return this;
    }

    public int getMaxPendingMessages() {
        return this.conf.getMaxPendingMessages();
    }

    public ProducerConfiguration setMaxPendingMessages(int maxPendingMessages) {
        this.conf.setMaxPendingMessages(maxPendingMessages);
        return this;
    }

    public HashingScheme getHashingScheme() {
        return HashingScheme.valueOf(this.conf.getHashingScheme().toString());
    }

    public ProducerConfiguration setHashingScheme(HashingScheme hashingScheme) {
        this.conf.setHashingScheme(org.apache.pulsar.client.api.HashingScheme.valueOf((String)hashingScheme.toString()));
        return this;
    }

    public int getMaxPendingMessagesAcrossPartitions() {
        return this.conf.getMaxPendingMessagesAcrossPartitions();
    }

    public void setMaxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
        this.conf.setMaxPendingMessagesAcrossPartitions(maxPendingMessagesAcrossPartitions);
    }

    public boolean getBlockIfQueueFull() {
        return this.conf.isBlockIfQueueFull();
    }

    public ProducerConfiguration setBlockIfQueueFull(boolean blockIfQueueFull) {
        this.conf.setBlockIfQueueFull(blockIfQueueFull);
        return this;
    }

    public ProducerConfiguration setMessageRoutingMode(MessageRoutingMode messageRouteMode) {
        Objects.requireNonNull(messageRouteMode);
        this.conf.setMessageRoutingMode(org.apache.pulsar.client.api.MessageRoutingMode.valueOf((String)messageRouteMode.toString()));
        return this;
    }

    public MessageRoutingMode getMessageRoutingMode() {
        return MessageRoutingMode.valueOf(this.conf.getMessageRoutingMode().toString());
    }

    public ProducerConfiguration setCompressionType(CompressionType compressionType) {
        this.conf.setCompressionType(compressionType);
        return this;
    }

    public CompressionType getCompressionType() {
        return this.conf.getCompressionType();
    }

    public ProducerConfiguration setMessageRouter(MessageRouter messageRouter) {
        Objects.requireNonNull(messageRouter);
        this.setMessageRoutingMode(MessageRoutingMode.CustomPartition);
        this.conf.setCustomMessageRouter(messageRouter);
        return this;
    }

    @Deprecated
    public MessageRouter getMessageRouter(int numPartitions) {
        return this.conf.getCustomMessageRouter();
    }

    public MessageRouter getMessageRouter() {
        return this.conf.getCustomMessageRouter();
    }

    public boolean getBatchingEnabled() {
        return this.conf.isBatchingEnabled();
    }

    public ProducerConfiguration setBatchingEnabled(boolean batchMessagesEnabled) {
        this.conf.setBatchingEnabled(batchMessagesEnabled);
        return this;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.conf.getCryptoKeyReader();
    }

    public ProducerConfiguration setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        Objects.requireNonNull(cryptoKeyReader);
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    public Set<String> getEncryptionKeys() {
        return this.conf.getEncryptionKeys();
    }

    public boolean isEncryptionEnabled() {
        return this.conf.isEncryptionEnabled();
    }

    public void addEncryptionKey(String key) {
        this.conf.getEncryptionKeys().add(key);
    }

    public void removeEncryptionKey(String key) {
        this.conf.getEncryptionKeys().remove(key);
    }

    public void setCryptoFailureAction(ProducerCryptoFailureAction action) {
        this.conf.setCryptoFailureAction(action);
    }

    public ProducerCryptoFailureAction getCryptoFailureAction() {
        return this.conf.getCryptoFailureAction();
    }

    public long getBatchingMaxPublishDelayMs() {
        return TimeUnit.MICROSECONDS.toMillis(this.conf.getBatchingMaxPublishDelayMicros());
    }

    public ProducerConfiguration setBatchingMaxPublishDelay(long batchDelay, TimeUnit timeUnit) {
        this.conf.setBatchingMaxPublishDelayMicros(batchDelay, timeUnit);
        return this;
    }

    public int getBatchingMaxMessages() {
        return this.conf.getBatchingMaxMessages();
    }

    public ProducerConfiguration setBatchingMaxMessages(int batchMessagesMaxMessagesPerBatch) {
        this.conf.setBatchingMaxMessages(batchMessagesMaxMessagesPerBatch);
        return this;
    }

    public Optional<Long> getInitialSequenceId() {
        return Optional.ofNullable(this.conf.getInitialSequenceId());
    }

    public ProducerConfiguration setInitialSequenceId(long initialSequenceId) {
        this.conf.setInitialSequenceId(Long.valueOf(initialSequenceId));
        return this;
    }

    public ProducerConfiguration setProperty(String key, String value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        this.conf.getProperties().put(key, value);
        return this;
    }

    public ProducerConfiguration setProperties(Map<String, String> properties) {
        this.conf.getProperties().putAll(properties);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.conf.getProperties();
    }

    public ProducerConfigurationData getProducerConfigurationData() {
        return this.conf;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerConfiguration)) {
            return false;
        }
        ProducerConfiguration other = (ProducerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProducerConfigurationData this$conf = this.conf;
        ProducerConfigurationData other$conf = other.conf;
        return !(this$conf == null ? other$conf != null : !this$conf.equals(other$conf));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProducerConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProducerConfigurationData $conf = this.conf;
        result = result * 59 + ($conf == null ? 43 : $conf.hashCode());
        return result;
    }

    @Deprecated
    public static enum HashingScheme {
        JavaStringHash,
        Murmur3_32Hash;

    }

    @Deprecated
    public static enum MessageRoutingMode {
        SinglePartition,
        RoundRobinPartition,
        CustomPartition;

    }
}

