/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.debezium;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerDeUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerDeUtils.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(String objectBase64Encoded, ClassLoader classLoader) {
        byte[] data = Base64.getDecoder().decode(objectBase64Encoded);
        try (ByteArrayInputStream bai = new ByteArrayInputStream(data);){
            Object object;
            try (PulsarClientBuilderInputStream ois = new PulsarClientBuilderInputStream(bai, classLoader);){
                object = ois.readObject();
            }
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize the pulsar client to store debezium database history", e);
        }
    }

    public static String serialize(Object obj) throws Exception {
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(bao);){
                oos.writeObject(obj);
                oos.flush();
                byte[] data = bao.toByteArray();
                string = Base64.getEncoder().encodeToString(data);
            }
            return string;
        }
    }

    static class PulsarClientBuilderInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public PulsarClientBuilderInputStream(InputStream in, ClassLoader ldr) throws IOException {
            super(in);
            this.classLoader = ldr;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), true, this.classLoader);
            }
            catch (Exception ex) {
                log.warn("PulsarClientBuilderInputStream resolveClass failed {} {}", (Object)desc.getName(), (Object)ex);
                return super.resolveClass(desc);
            }
        }
    }
}

