/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.opentelemetry;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.List;

public interface OpenTelemetryAttributes {
    public static final AttributeKey<String> PULSAR_CLUSTER = AttributeKey.stringKey((String)"pulsar.cluster");
    public static final AttributeKey<String> PULSAR_NAMESPACE = AttributeKey.stringKey((String)"pulsar.namespace");
    public static final AttributeKey<String> PULSAR_TENANT = AttributeKey.stringKey((String)"pulsar.tenant");
    public static final AttributeKey<String> PULSAR_DOMAIN = AttributeKey.stringKey((String)"pulsar.domain");
    public static final AttributeKey<String> PULSAR_TOPIC = AttributeKey.stringKey((String)"pulsar.topic");
    public static final AttributeKey<Long> PULSAR_PARTITION_INDEX = AttributeKey.longKey((String)"pulsar.partition.index");
    public static final AttributeKey<String> PULSAR_SUBSCRIPTION_NAME = AttributeKey.stringKey((String)"pulsar.subscription.name");
    public static final AttributeKey<String> PULSAR_SUBSCRIPTION_TYPE = AttributeKey.stringKey((String)"pulsar.subscription.type");
    public static final AttributeKey<String> PULSAR_CONSUMER_NAME = AttributeKey.stringKey((String)"pulsar.consumer.name");
    public static final AttributeKey<Long> PULSAR_CONSUMER_ID = AttributeKey.longKey((String)"pulsar.consumer.id");
    public static final AttributeKey<List<String>> PULSAR_CONSUMER_METADATA = AttributeKey.stringArrayKey((String)"pulsar.consumer.metadata");
    public static final AttributeKey<Long> PULSAR_CONSUMER_CONNECTED_SINCE = AttributeKey.longKey((String)"pulsar.consumer.connected_since");
    public static final AttributeKey<String> PULSAR_PRODUCER_NAME = AttributeKey.stringKey((String)"pulsar.producer.name");
    public static final AttributeKey<Long> PULSAR_PRODUCER_ID = AttributeKey.longKey((String)"pulsar.producer.id");
    public static final AttributeKey<String> PULSAR_PRODUCER_ACCESS_MODE = AttributeKey.stringKey((String)"pulsar.producer.access_mode");
    public static final AttributeKey<String> PULSAR_CLIENT_ADDRESS = AttributeKey.stringKey((String)"pulsar.client.address");
    public static final AttributeKey<String> PULSAR_CLIENT_VERSION = AttributeKey.stringKey((String)"pulsar.client.version");
    public static final AttributeKey<String> PULSAR_CONNECTION_RATE_LIMIT_OPERATION_NAME = AttributeKey.stringKey((String)"pulsar.connection.rate_limit.operation.name");
    public static final AttributeKey<String> PULSAR_TRANSACTION_STATUS = AttributeKey.stringKey((String)"pulsar.transaction.status");
    public static final AttributeKey<String> PULSAR_TRANSACTION_ACK_STORE_OPERATION_STATUS = AttributeKey.stringKey((String)"pulsar.transaction.pending.ack.store.operation.status");
    public static final AttributeKey<Long> PULSAR_TRANSACTION_COORDINATOR_ID = AttributeKey.longKey((String)"pulsar.transaction.coordinator.id");
    public static final AttributeKey<String> PULSAR_TRANSACTION_BUFFER_CLIENT_OPERATION_STATUS = AttributeKey.stringKey((String)"pulsar.transaction.buffer.client.operation.status");
    public static final AttributeKey<String> PULSAR_COMPACTION_STATUS = AttributeKey.stringKey((String)"pulsar.compaction.status");
    public static final AttributeKey<String> PULSAR_BACKLOG_QUOTA_TYPE = AttributeKey.stringKey((String)"pulsar.backlog.quota.type");
    public static final AttributeKey<String> ML_LEDGER_NAME = AttributeKey.stringKey((String)"pulsar.managed_ledger.name");
    public static final AttributeKey<String> ML_CURSOR_NAME = AttributeKey.stringKey((String)"pulsar.managed_ledger.cursor.name");
    public static final AttributeKey<String> ML_CURSOR_OPERATION_STATUS = AttributeKey.stringKey((String)"pulsar.managed_ledger.cursor.operation.status");
    public static final AttributeKey<String> MANAGED_LEDGER_READ_INFLIGHT_USAGE = AttributeKey.stringKey((String)"pulsar.managed_ledger.inflight.read.usage.state");
    public static final AttributeKey<String> PULSAR_REPLICATION_REMOTE_CLUSTER_NAME = AttributeKey.stringKey((String)"pulsar.replication.remote.cluster.name");
    public static final AttributeKey<String> PULSAR_CONNECTION_STATUS = AttributeKey.stringKey((String)"pulsar.connection.status");
    public static final AttributeKey<String> PULSAR_CONNECTION_CREATE_STATUS = AttributeKey.stringKey((String)"pulsar.connection.create.operation.status");
    public static final AttributeKey<String> ML_NAME = AttributeKey.stringKey((String)"pulsar.managed_ledger.name");
    public static final AttributeKey<String> ML_OPERATION_STATUS = AttributeKey.stringKey((String)"pulsar.managed_ledger.operation.status");
    public static final AttributeKey<String> ML_POOL_ARENA_TYPE = AttributeKey.stringKey((String)"pulsar.managed_ledger.pool.arena.type");
    public static final AttributeKey<String> ML_POOL_CHUNK_ALLOCATION_TYPE = AttributeKey.stringKey((String)"pulsar.managed_ledger.pool.chunk.allocation.type");
    public static final AttributeKey<String> ML_CACHE_ENTRY_STATUS = AttributeKey.stringKey((String)"pulsar.managed_ledger.cache.entry.status");
    public static final AttributeKey<String> ML_CACHE_OPERATION_STATUS = AttributeKey.stringKey((String)"pulsar.managed_ledger.cache.operation.status");

    public static enum CacheOperationStatus {
        HIT,
        MISS;

        public final Attributes attributes = Attributes.of(ML_CACHE_OPERATION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum CacheEntryStatus {
        ACTIVE,
        EVICTED,
        INSERTED;

        public final Attributes attributes = Attributes.of(ML_CACHE_ENTRY_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum PoolChunkAllocationType {
        ALLOCATED,
        USED;

        public final Attributes attributes = Attributes.of(ML_POOL_CHUNK_ALLOCATION_TYPE, (Object)this.name().toLowerCase());
    }

    public static enum PoolArenaType {
        SMALL,
        NORMAL,
        HUGE;

        public final Attributes attributes = Attributes.of(ML_POOL_ARENA_TYPE, (Object)this.name().toLowerCase());
    }

    public static enum ManagedLedgerOperationStatus {
        SUCCESS,
        FAILURE;

        public final Attributes attributes = Attributes.of(ML_OPERATION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum ConnectionCreateStatus {
        SUCCESS,
        FAILURE;

        public final Attributes attributes = Attributes.of(PULSAR_CONNECTION_CREATE_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum ConnectionStatus {
        ACTIVE,
        OPEN,
        CLOSE;

        public final Attributes attributes = Attributes.of(PULSAR_CONNECTION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum InflightReadLimiterUtilization {
        USED,
        FREE;

        public final Attributes attributes = Attributes.of(MANAGED_LEDGER_READ_INFLIGHT_USAGE, (Object)this.name().toLowerCase());
    }

    public static enum ManagedCursorOperationStatus {
        SUCCESS,
        FAILURE;

        public final Attributes attributes = Attributes.of(ML_CURSOR_OPERATION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum BacklogQuotaType {
        SIZE,
        TIME;

        public final Attributes attributes = Attributes.of(PULSAR_BACKLOG_QUOTA_TYPE, (Object)this.name().toLowerCase());
    }

    public static enum CompactionStatus {
        SUCCESS,
        FAILURE;

        public final Attributes attributes = Attributes.of(PULSAR_COMPACTION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum TransactionBufferClientOperationStatus {
        SUCCESS,
        FAILURE;

        public final Attributes attributes = Attributes.of(PULSAR_TRANSACTION_BUFFER_CLIENT_OPERATION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum TransactionPendingAckOperationStatus {
        SUCCESS,
        FAILURE;

        public final Attributes attributes = Attributes.of(PULSAR_TRANSACTION_ACK_STORE_OPERATION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum TransactionStatus {
        ABORTED,
        ACTIVE,
        COMMITTED,
        CREATED,
        TIMEOUT;

        public final Attributes attributes = Attributes.of(PULSAR_TRANSACTION_STATUS, (Object)this.name().toLowerCase());
    }

    public static enum ConnectionRateLimitOperationName {
        PAUSED,
        RESUMED,
        THROTTLED,
        UNTHROTTLED;

        public final Attributes attributes = Attributes.of(PULSAR_CONNECTION_RATE_LIMIT_OPERATION_NAME, (Object)this.name().toLowerCase());
    }
}

