/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.testclient.PerformanceBaseArguments;
import org.apache.pulsar.testclient.PositiveNumberParameterValidator;

public abstract class PerformanceTopicListArguments
extends PerformanceBaseArguments {
    @Parameter(description="persistent://prop/ns/my-topic", required=true)
    public List<String> topics;
    @Parameter(names={"-t", "--num-topics", "--num-topic"}, description="Number of topics.  Must matchthe given number of topic arguments.", validateWith={PositiveNumberParameterValidator.class})
    public int numTopics = 1;

    @Override
    public void validate() throws Exception {
        super.validate();
        for (String arg : this.topics) {
            if (!arg.startsWith("-")) continue;
            String errMsg = String.format("invalid option: '%s', to use a topic with the name '%s', please use a fully qualified topic name", arg, arg);
            throw new Exception(errMsg);
        }
        if (this.topics.size() != this.numTopics) {
            if (this.topics.size() == 1) {
                String prefixTopicName = TopicName.get((String)this.topics.get(0)).toString().trim();
                ArrayList<String> defaultTopics = new ArrayList<String>();
                for (int i = 0; i < this.numTopics; ++i) {
                    defaultTopics.add(String.format("%s-%d", prefixTopicName, i));
                }
                this.topics = defaultTopics;
            } else {
                String errMsg = String.format("the number of topic names (%d) must be equal to --num-topics (%d)", this.topics.size(), this.numTopics);
                throw new Exception(errMsg);
            }
        }
    }
}

