/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.spark.launcher.BaseSuite;
import org.apache.spark.launcher.SparkSubmitOptionParser;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SparkSubmitOptionParserSuite
extends BaseSuite {
    private SparkSubmitOptionParser parser;

    @Before
    public void setUp() {
        this.parser = (SparkSubmitOptionParser)Mockito.spy((Object)((Object)new DummyParser()));
    }

    @Test
    public void testAllOptions() {
        int count = 0;
        String[][] stringArray = this.parser.opts;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] optNames;
            for (String optName : optNames = stringArray[i]) {
                String value = optName + "-value";
                this.parser.parse(Arrays.asList(optName, value));
                ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser)).handle((String)Mockito.eq((Object)optNames[0]), (String)Mockito.eq((Object)value));
                ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser, (VerificationMode)Mockito.times((int)(++count)))).handle(Mockito.anyString(), Mockito.anyString());
                ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser, (VerificationMode)Mockito.times((int)count))).handleExtraArgs((List)Mockito.eq(Collections.emptyList()));
            }
        }
        for (String[] switchNames : this.parser.switches) {
            int switchCount = 0;
            for (String name : switchNames) {
                this.parser.parse(Arrays.asList(name));
                ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser, (VerificationMode)Mockito.times((int)(++switchCount)))).handle((String)Mockito.eq((Object)switchNames[0]), (String)Mockito.same(null));
                ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser, (VerificationMode)Mockito.times((int)(++count)))).handle(Mockito.anyString(), (String)Mockito.any(String.class));
                ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser, (VerificationMode)Mockito.times((int)count))).handleExtraArgs((List)Mockito.eq(Collections.emptyList()));
            }
        }
    }

    @Test
    public void testExtraOptions() {
        String[] stringArray = new String[4];
        Objects.requireNonNull(this.parser);
        stringArray[0] = "--master";
        Objects.requireNonNull(this.parser);
        stringArray[1] = "--master";
        stringArray[2] = "foo";
        stringArray[3] = "bar";
        List<String> args = Arrays.asList(stringArray);
        this.parser.parse(args);
        SparkSubmitOptionParser sparkSubmitOptionParser = (SparkSubmitOptionParser)Mockito.verify((Object)this.parser);
        Objects.requireNonNull(this.parser);
        String string = (String)Mockito.eq((Object)"--master");
        Objects.requireNonNull(this.parser);
        sparkSubmitOptionParser.handle(string, (String)Mockito.eq((Object)"--master"));
        ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser)).handleUnknown((String)Mockito.eq((Object)"foo"));
        ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser)).handleExtraArgs((List)Mockito.eq(Arrays.asList("bar")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingArg() {
        String[] stringArray = new String[1];
        Objects.requireNonNull(this.parser);
        stringArray[0] = "--master";
        this.parser.parse(Arrays.asList(stringArray));
    }

    @Test
    public void testEqualSeparatedOption() {
        String[] stringArray = new String[1];
        StringBuilder stringBuilder = new StringBuilder();
        Objects.requireNonNull(this.parser);
        StringBuilder stringBuilder2 = stringBuilder.append("--master").append("=");
        Objects.requireNonNull(this.parser);
        stringArray[0] = stringBuilder2.append("--master").toString();
        List<String> args = Arrays.asList(stringArray);
        this.parser.parse(args);
        SparkSubmitOptionParser sparkSubmitOptionParser = (SparkSubmitOptionParser)Mockito.verify((Object)this.parser);
        Objects.requireNonNull(this.parser);
        String string = (String)Mockito.eq((Object)"--master");
        Objects.requireNonNull(this.parser);
        sparkSubmitOptionParser.handle(string, (String)Mockito.eq((Object)"--master"));
        ((SparkSubmitOptionParser)Mockito.verify((Object)this.parser)).handleExtraArgs((List)Mockito.eq(Collections.emptyList()));
    }

    private static class DummyParser
    extends SparkSubmitOptionParser {
        private DummyParser() {
        }

        protected boolean handle(String opt, String value) {
            return true;
        }

        protected boolean handleUnknown(String opt) {
            return false;
        }

        protected void handleExtraArgs(List<String> extra) {
        }
    }
}

