/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class CommandArgsSanitizer {
    private static final List<String> sanitizableArgs = Arrays.asList("hive.server2.keystore.password=", "spark.cassandra.auth.password=", "spark.cassandra.connection.ssl.keyStore.password=", "spark.cassandra.connection.ssl.trustStore.password=");

    CommandArgsSanitizer() {
    }

    public static List<String> sanitizeCommand(List<String> cmd) {
        return cmd.stream().map(CommandArgsSanitizer::sanitize).collect(Collectors.toList());
    }

    private static String sanitize(String arg) {
        String sanitizedArg = arg;
        for (String sanitizableArg : sanitizableArgs) {
            if (!arg.startsWith(sanitizableArg)) continue;
            sanitizedArg = sanitizableArg + "*****";
            break;
        }
        return sanitizedArg;
    }
}

