/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.TestShuffleDataContext;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.Assert;
import org.junit.Test;

public class ExternalShuffleCleanupSuite {
    private Executor sameThreadExecutor = MoreExecutors.sameThreadExecutor();
    private TransportConf conf = new TransportConf("shuffle", (ConfigProvider)MapConfigProvider.EMPTY);
    private static final String SORT_MANAGER = "org.apache.spark.shuffle.sort.SortShuffleManager";

    @Test
    public void noCleanupAndCleanup() throws IOException {
        TestShuffleDataContext dataContext = ExternalShuffleCleanupSuite.createSomeData();
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app", "exec0", dataContext.createExecutorInfo(SORT_MANAGER));
        resolver.applicationRemoved("app", false);
        ExternalShuffleCleanupSuite.assertStillThere(dataContext);
        resolver.registerExecutor("app", "exec1", dataContext.createExecutorInfo(SORT_MANAGER));
        resolver.applicationRemoved("app", true);
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext);
    }

    @Test
    public void cleanupUsesExecutor() throws IOException {
        TestShuffleDataContext dataContext = ExternalShuffleCleanupSuite.createSomeData();
        AtomicBoolean cleanupCalled = new AtomicBoolean(false);
        Executor noThreadExecutor = runnable -> cleanupCalled.set(true);
        ExternalShuffleBlockResolver manager = new ExternalShuffleBlockResolver(this.conf, null, noThreadExecutor);
        manager.registerExecutor("app", "exec0", dataContext.createExecutorInfo(SORT_MANAGER));
        manager.applicationRemoved("app", true);
        Assert.assertTrue((boolean)cleanupCalled.get());
        ExternalShuffleCleanupSuite.assertStillThere(dataContext);
        dataContext.cleanup();
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext);
    }

    @Test
    public void cleanupMultipleExecutors() throws IOException {
        TestShuffleDataContext dataContext0 = ExternalShuffleCleanupSuite.createSomeData();
        TestShuffleDataContext dataContext1 = ExternalShuffleCleanupSuite.createSomeData();
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app", "exec0", dataContext0.createExecutorInfo(SORT_MANAGER));
        resolver.registerExecutor("app", "exec1", dataContext1.createExecutorInfo(SORT_MANAGER));
        resolver.applicationRemoved("app", true);
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext0);
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext1);
    }

    @Test
    public void cleanupOnlyRemovedApp() throws IOException {
        TestShuffleDataContext dataContext0 = ExternalShuffleCleanupSuite.createSomeData();
        TestShuffleDataContext dataContext1 = ExternalShuffleCleanupSuite.createSomeData();
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app-0", "exec0", dataContext0.createExecutorInfo(SORT_MANAGER));
        resolver.registerExecutor("app-1", "exec0", dataContext1.createExecutorInfo(SORT_MANAGER));
        resolver.applicationRemoved("app-nonexistent", true);
        ExternalShuffleCleanupSuite.assertStillThere(dataContext0);
        ExternalShuffleCleanupSuite.assertStillThere(dataContext1);
        resolver.applicationRemoved("app-0", true);
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext0);
        ExternalShuffleCleanupSuite.assertStillThere(dataContext1);
        resolver.applicationRemoved("app-1", true);
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext0);
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext1);
        resolver.applicationRemoved("app-1", true);
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext0);
        ExternalShuffleCleanupSuite.assertCleanedUp(dataContext1);
    }

    private static void assertStillThere(TestShuffleDataContext dataContext) {
        for (String localDir : dataContext.localDirs) {
            Assert.assertTrue((String)(localDir + " was cleaned up prematurely"), (boolean)new File(localDir).exists());
        }
    }

    private static void assertCleanedUp(TestShuffleDataContext dataContext) {
        for (String localDir : dataContext.localDirs) {
            Assert.assertFalse((String)(localDir + " wasn't cleaned up"), (boolean)new File(localDir).exists());
        }
    }

    private static TestShuffleDataContext createSomeData() throws IOException {
        Random rand = new Random(123L);
        TestShuffleDataContext dataContext = new TestShuffleDataContext(10, 5);
        dataContext.create();
        dataContext.insertSortShuffleData(rand.nextInt(1000), rand.nextInt(1000), new byte[][]{"ABC".getBytes(StandardCharsets.UTF_8), "DEF".getBytes(StandardCharsets.UTF_8)});
        return dataContext;
    }
}

