/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Enumeration;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.repl.ExecutorClassLoader;
import org.apache.spark.repl.ExecutorClassLoaderSuite$;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.util.Utils$;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001-\u0011\u0001$\u0012=fGV$xN]\"mCN\u001cHj\\1eKJ\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003sKBd'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0004\t\u00179A\u0011QBD\u0007\u0002\t%\u0011q\u0002\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005E!R\"\u0001\n\u000b\u0005MA\u0011!C:dC2\fG/Z:u\u0013\t)\"CA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\n\u0002\u000f5|7m[5u_&\u00111\u0004\u0007\u0002\r\u001b>\u001c7.\u001b;p'V<\u0017M\u001d\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u0011\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Cy\u0011q\u0001T8hO&tw\rC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u0005!9\u0001\u0006\u0001b\u0001\n\u0003I\u0013aD2iS2$7\t\\1tg:\u000bW.Z:\u0016\u0003)\u00022a\u000b\u001a5\u001b\u0005a#BA\u0017/\u0003%IW.\\;uC\ndWM\u0003\u00020a\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003E\nQa]2bY\u0006L!a\r\u0017\u0003\t1K7\u000f\u001e\t\u0003kij\u0011A\u000e\u0006\u0003oa\nA\u0001\\1oO*\t\u0011(\u0001\u0003kCZ\f\u0017BA\u001e7\u0005\u0019\u0019FO]5oO\"1Q\b\u0001Q\u0001\n)\n\u0001c\u00195jY\u0012\u001cE.Y:t\u001d\u0006lWm\u001d\u0011\t\u000f}\u0002!\u0019!C\u0001S\u0005\u0001\u0002/\u0019:f]R\u001cE.Y:t\u001d\u0006lWm\u001d\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u0016\u0002#A\f'/\u001a8u\u00072\f7o\u001d(b[\u0016\u001c\b\u0005C\u0004D\u0001\t\u0007I\u0011A\u0015\u0002'A\f'/\u001a8u%\u0016\u001cx.\u001e:dK:\u000bW.Z:\t\r\u0015\u0003\u0001\u0015!\u0003+\u0003Q\u0001\u0018M]3oiJ+7o\\;sG\u0016t\u0015-\\3tA!Iq\t\u0001a\u0001\u0002\u0004%\t\u0001S\u0001\ti\u0016l\u0007\u000fR5scU\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002Mq\u0005\u0011\u0011n\\\u0005\u0003\u001d.\u0013AAR5mK\"I\u0001\u000b\u0001a\u0001\u0002\u0004%\t!U\u0001\ri\u0016l\u0007\u000fR5sc}#S-\u001d\u000b\u0003%Z\u0003\"a\u0015+\u000e\u0003AJ!!\u0016\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b/>\u000b\t\u00111\u0001J\u0003\rAH%\r\u0005\u00073\u0002\u0001\u000b\u0015B%\u0002\u0013Q,W\u000e\u001d#jeF\u0002\u0003\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0001I\u0003!!X-\u001c9ESJ\u0014\u0004\"C/\u0001\u0001\u0004\u0005\r\u0011\"\u0001_\u00031!X-\u001c9ESJ\u0014t\fJ3r)\t\u0011v\fC\u0004X9\u0006\u0005\t\u0019A%\t\r\u0005\u0004\u0001\u0015)\u0003J\u0003%!X-\u001c9ESJ\u0014\u0004\u0005C\u0005d\u0001\u0001\u0007\t\u0019!C\u0001I\u0006!QO\u001d72+\u0005)\u0007C\u00014j\u001d\t\u0019v-\u0003\u0002ia\u00051\u0001K]3eK\u001aL!a\u000f6\u000b\u0005!\u0004\u0004\"\u00037\u0001\u0001\u0004\u0005\r\u0011\"\u0001n\u0003!)(\u000f\\\u0019`I\u0015\fHC\u0001*o\u0011\u001d96.!AA\u0002\u0015Da\u0001\u001d\u0001!B\u0013)\u0017!B;sYF\u0002\u0003\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0001t\u0003\u0015)(\u000f\\:3+\u0005!\bcA*vo&\u0011a\u000f\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003qnl\u0011!\u001f\u0006\u0003ub\n1A\\3u\u0013\ta\u0018PA\u0002V%2C\u0011B \u0001A\u0002\u0003\u0007I\u0011A@\u0002\u0013U\u0014Hn\u001d\u001a`I\u0015\fHc\u0001*\u0002\u0002!9q+`A\u0001\u0002\u0004!\bbBA\u0003\u0001\u0001\u0006K\u0001^\u0001\u0007kJd7O\r\u0011\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002%\"9\u0011q\u0002\u0001\u0005B\u0005-\u0011\u0001C1gi\u0016\u0014\u0018\t\u001c7")
public class ExecutorClassLoaderSuite
extends SparkFunSuite
implements MockitoSugar {
    private final List<String> childClassNames;
    private final List<String> parentClassNames;
    private final List<String> parentResourceNames;
    private File tempDir1;
    private File tempDir2;
    private String url1;
    private URL[] urls2;

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, classTag);
    }

    public List<String> childClassNames() {
        return this.childClassNames;
    }

    public List<String> parentClassNames() {
        return this.parentClassNames;
    }

    public List<String> parentResourceNames() {
        return this.parentResourceNames;
    }

    public File tempDir1() {
        return this.tempDir1;
    }

    public void tempDir1_$eq(File x$1) {
        this.tempDir1 = x$1;
    }

    public File tempDir2() {
        return this.tempDir2;
    }

    public void tempDir2_$eq(File x$1) {
        this.tempDir2 = x$1;
    }

    public String url1() {
        return this.url1;
    }

    public void url1_$eq(String x$1) {
        this.url1 = x$1;
    }

    public URL[] urls2() {
        return this.urls2;
    }

    public void urls2_$eq(URL[] x$1) {
        this.urls2 = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.tempDir1_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.tempDir2_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.url1_$eq(this.tempDir1().toURI().toURL().toString());
        this.urls2_$eq((URL[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URL[]{this.tempDir2().toURI().toURL()})).toArray(ClassTag$.MODULE$.apply(URL.class)));
        this.childClassNames().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final File apply(String x$1) {
                return TestUtils$.MODULE$.createCompiledClass(x$1, this.$outer.tempDir1(), "1", TestUtils$.MODULE$.createCompiledClass$default$4(), TestUtils$.MODULE$.createCompiledClass$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.parentResourceNames().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final void apply(String x) {
                Files.write((byte[])"resource".getBytes(StandardCharsets.UTF_8), (File)new File(this.$outer.tempDir2(), x));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.parentClassNames().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final File apply(String x$2) {
                return TestUtils$.MODULE$.createCompiledClass(x$2, this.$outer.tempDir2(), "2", TestUtils$.MODULE$.createCompiledClass$default$4(), TestUtils$.MODULE$.createCompiledClass$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.tempDir1());
            Utils$.MODULE$.deleteRecursively(this.tempDir2());
            SparkEnv$.MODULE$.set(null);
            return;
        }
        finally {
            super.afterAll();
        }
    }

    public ExecutorClassLoaderSuite() {
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.childClassNames = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ReplFakeClass1", "ReplFakeClass2"}));
        this.parentClassNames = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ReplFakeClass1", "ReplFakeClass2", "ReplFakeClass3"}));
        this.parentResourceNames = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fake-resource.txt"}));
        this.test("child over system classloader", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final Assertion apply() {
                SimpleJavaFileObject scalaOptionFile = new SimpleJavaFileObject(this){

                    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                        return "package scala; class Option {}";
                    }
                };
                ToolProvider.getSystemJavaCompiler().getTask(null, null, null, null, null, Collections.singletonList(scalaOptionFile)).call();
                File scalaDir = new File(this.$outer.tempDir1(), "scala");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(scalaDir.mkdir(), "scalaDir.mkdir()", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create 'scala' directory in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tempDir1()})), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
                String filename = "Option.class";
                File result = new File(filename);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(result.exists(), "result.exists()", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder().append((Object)"Compiled file not found: ").append((Object)result.getAbsolutePath()).toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
                File out = new File(scalaDir, filename);
                Files.move((File)result, (File)out);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(out.exists(), "out.exists()", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder().append((Object)"Destination file not moved: ").append((Object)out.getAbsolutePath()).toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                URLClassLoader parentLoader = new URLClassLoader(this.$outer.urls2(), null);
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.$outer.url1(), (ClassLoader)parentLoader, true);
                Class<?> optionClass = Class.forName("scala.Option", false, (ClassLoader)classLoader);
                ClassLoader $org_scalatest_assert_macro_left = optionClass.getClassLoader();
                ExecutorClassLoader $org_scalatest_assert_macro_right = classLoader;
                ClassLoader classLoader2 = $org_scalatest_assert_macro_left;
                ExecutorClassLoader executorClassLoader = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(classLoader2 != null ? !classLoader2.equals(executorClassLoader) : executorClassLoader != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"scala.Option didn't come from ExecutorClassLoader", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("child first", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final Assertion apply() {
                URLClassLoader parentLoader = new URLClassLoader(this.$outer.urls2(), null);
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.$outer.url1(), (ClassLoader)parentLoader, true);
                T fakeClass = classLoader.loadClass("ReplFakeClass2").newInstance();
                String fakeClassVersion = fakeClass.toString();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(fakeClassVersion);
                String $org_scalatest_assert_macro_right = "1";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("parent first", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final Assertion apply() {
                URLClassLoader parentLoader = new URLClassLoader(this.$outer.urls2(), null);
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.$outer.url1(), (ClassLoader)parentLoader, false);
                T fakeClass = classLoader.loadClass("ReplFakeClass1").newInstance();
                String fakeClassVersion = fakeClass.toString();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(fakeClassVersion);
                String $org_scalatest_assert_macro_right = "2";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("child first can fall back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final Assertion apply() {
                URLClassLoader parentLoader = new URLClassLoader(this.$outer.urls2(), null);
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.$outer.url1(), (ClassLoader)parentLoader, true);
                T fakeClass = classLoader.loadClass("ReplFakeClass3").newInstance();
                String fakeClassVersion = fakeClass.toString();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(fakeClassVersion);
                String $org_scalatest_assert_macro_right = "2";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("child first can fail", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final ClassNotFoundException apply() {
                URLClassLoader parentLoader = new URLClassLoader(this.$outer.urls2(), null);
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.$outer.url1(), (ClassLoader)parentLoader, true);
                return (ClassNotFoundException)this.$outer.intercept((Function0)new Serializable(this, classLoader){
                    public static final long serialVersionUID = 0L;
                    private final ExecutorClassLoader classLoader$1;

                    public final Object apply() {
                        return this.classLoader$1.loadClass("ReplFakeClassDoesNotExist").newInstance();
                    }
                    {
                        this.classLoader$1 = classLoader$1;
                    }
                }, ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("resource from parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final Assertion apply() {
                InputStream is;
                URLClassLoader parentLoader = new URLClassLoader(this.$outer.urls2(), null);
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.$outer.url1(), (ClassLoader)parentLoader, true);
                String resourceName = (String)this.$outer.parentResourceNames().head();
                InputStream $org_scalatest_assert_macro_left = is = classLoader.getResourceAsStream(resourceName);
                Object $org_scalatest_assert_macro_right = null;
                InputStream inputStream = $org_scalatest_assert_macro_left;
                Object var8_7 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, inputStream != null ? !inputStream.equals(var8_7) : var8_7 != null, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource ", " not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceName})), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                BufferedSource bufferedSource = Source$.MODULE$.fromInputStream(is, "UTF-8");
                return (Assertion)Utils$.MODULE$.tryWithSafeFinally((Function0)new Serializable(this, bufferedSource){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final BufferedSource bufferedSource$1;

                    public final Assertion apply() {
                        String content;
                        String $org_scalatest_assert_macro_left = content = (String)this.bufferedSource$1.getLines().next();
                        String $org_scalatest_assert_macro_right = "resource";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$repl$ExecutorClassLoaderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"File doesn't contain 'resource'", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.bufferedSource$1 = bufferedSource$1;
                    }
                }, (Function0)new Serializable(this, bufferedSource){
                    public static final long serialVersionUID = 0L;
                    private final BufferedSource bufferedSource$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.bufferedSource$1.close();
                    }
                    {
                        this.bufferedSource$1 = bufferedSource$1;
                    }
                });
            }

            public /* synthetic */ ExecutorClassLoaderSuite org$apache$spark$repl$ExecutorClassLoaderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("resources from parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final Assertion apply() {
                URLClassLoader parentLoader = new URLClassLoader(this.$outer.urls2(), null);
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.$outer.url1(), (ClassLoader)parentLoader, true);
                String resourceName = (String)this.$outer.parentResourceNames().head();
                Enumeration resources = classLoader.getResources(resourceName);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(resources.hasMoreElements(), "resources.hasMoreElements()", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource ", " not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceName})), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
                BufferedSource bufferedSource = Source$.MODULE$.fromInputStream(((URL)resources.nextElement()).openStream(), Codec$.MODULE$.fallbackSystemCodec());
                return (Assertion)Utils$.MODULE$.tryWithSafeFinally((Function0)new Serializable(this, bufferedSource){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final BufferedSource bufferedSource$2;

                    public final Assertion apply() {
                        BufferedReader fileReader = this.bufferedSource$2.bufferedReader();
                        String $org_scalatest_assert_macro_left = fileReader.readLine();
                        String $org_scalatest_assert_macro_right = "resource";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$repl$ExecutorClassLoaderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"File doesn't contain 'resource'", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.bufferedSource$2 = bufferedSource$2;
                    }
                }, (Function0)new Serializable(this, bufferedSource){
                    public static final long serialVersionUID = 0L;
                    private final BufferedSource bufferedSource$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.bufferedSource$2.close();
                    }
                    {
                        this.bufferedSource$2 = bufferedSource$2;
                    }
                });
            }

            public /* synthetic */ ExecutorClassLoaderSuite org$apache$spark$repl$ExecutorClassLoaderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("fetch classes using Spark's RpcEnv", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorClassLoaderSuite $outer;

            public final ClassNotFoundException apply() {
                SparkEnv env = (SparkEnv)this.$outer.mock(ClassTag$.MODULE$.apply(SparkEnv.class));
                RpcEnv rpcEnv = (RpcEnv)this.$outer.mock(ClassTag$.MODULE$.apply(RpcEnv.class));
                Mockito.when((Object)env.rpcEnv()).thenReturn((Object)rpcEnv);
                Mockito.when((Object)rpcEnv.openChannel(Matchers.anyString())).thenAnswer((Answer)new Answer<ReadableByteChannel>(this){
                    private final /* synthetic */ $anonfun$8 $outer;

                    public ReadableByteChannel answer(InvocationOnMock invocation) {
                        URI uri = new URI((String)invocation.getArguments()[0]);
                        Path path = Paths.get(this.$outer.org$apache$spark$repl$ExecutorClassLoaderSuite$$anonfun$$$outer().tempDir1().getAbsolutePath(), new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).stripPrefix("/"));
                        return FileChannel.open(path, StandardOpenOption.READ);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), env, "spark://localhost:1234", ((Object)((Object)this.$outer)).getClass().getClassLoader(), false);
                T fakeClass = classLoader.loadClass("ReplFakeClass2").newInstance();
                String fakeClassVersion = fakeClass.toString();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(fakeClassVersion);
                String $org_scalatest_assert_macro_right = "1";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
                return (ClassNotFoundException)this.$outer.intercept((Function0)new Serializable(this, classLoader){
                    public static final long serialVersionUID = 0L;
                    private final ExecutorClassLoader classLoader$2;

                    public final Object apply() {
                        return this.classLoader$2.loadClass("ReplFakeClassDoesNotExist").newInstance();
                    }
                    {
                        this.classLoader$2 = classLoader$2;
                    }
                }, ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            }

            public /* synthetic */ ExecutorClassLoaderSuite org$apache$spark$repl$ExecutorClassLoaderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
    }
}

