/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.repl.Main$;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u0017\t\u00112+\u001b8hY\u0016$xN\u001c*fa2\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003sKBd'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001b9i\u0011\u0001B\u0005\u0003\u001f\u0011\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\n]\t1a\\;u+\u0005A\u0002CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\tIwNC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"\u0001D*ue&twm\u0016:ji\u0016\u0014\bBB\u0011\u0001A\u0003%\u0001$\u0001\u0003pkR\u0004\u0003bB\u0012\u0001\u0005\u0004%I\u0001J\u0001\u0003S:,\u0012!\n\t\u00033\u0019J!a\n\u000e\u0003#AK\u0007/\u001a3PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004*\u0001\u0001\u0006I!J\u0001\u0004S:\u0004\u0003\"C\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003-\u0003\u0019!\bN]3bIV\tQ\u0006\u0005\u0002/c5\tqF\u0003\u000219\u0005!A.\u00198h\u0013\t\u0011tF\u0001\u0004UQJ,\u0017\r\u001a\u0005\ni\u0001\u0001\r\u00111A\u0005\nU\n!\u0002\u001e5sK\u0006$w\fJ3r)\t1D\b\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0003V]&$\bbB\u001f4\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0004BB \u0001A\u0003&Q&A\u0004uQJ,\u0017\r\u001a\u0011\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\u000692i\u0014(G?\u0016CViQ+U\u001fJ{6\tT!T'B\u000bE\u000bS\u000b\u0002\u0007B\u0011a\u0006R\u0005\u0003\u000b>\u0012aa\u0015;sS:<\u0007BB$\u0001A\u0003%1)\u0001\rD\u001f:3u,\u0012-F\u0007V#vJU0D\u0019\u0006\u001b6\u000bU!U\u0011\u0002Bq!\u0013\u0001C\u0002\u0013%!)\u0001\u000bpY\u0012,\u00050Z2vi>\u00148\t\\1tgB\fG\u000f\u001b\u0005\u0007\u0017\u0002\u0001\u000b\u0011B\"\u0002+=dG-\u0012=fGV$xN]\"mCN\u001c\b/\u0019;iA!)Q\n\u0001C!\u001d\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002m!)\u0001\u000b\u0001C!\u001d\u0006A\u0011M\u001a;fe\u0006cG\u000eC\u0003S\u0001\u0011%1+A\u0005xC&$XK\u001c;jYR\u0011a\u0007\u0016\u0005\u0006+F\u0003\rAV\u0001\u0005G>tG\rE\u00028/fK!\u0001\u0017\u001d\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA\u001c[\u0013\tY\u0006HA\u0004C_>dW-\u00198\t\u000bu\u0003A\u0011\u00010\u0002\u001dI,h.\u00138uKJ\u0004(/\u001a;feR\u0011q,\u001a\t\u0003A\u000et!aN1\n\u0005\tD\u0014A\u0002)sK\u0012,g-\u0003\u0002FI*\u0011!\r\u000f\u0005\u0006Mr\u0003\raX\u0001\u0006S:\u0004X\u000f\u001e\u0005\u0006Q\u0002!\t![\u0001\u000fCN\u001cXM\u001d;D_:$\u0018-\u001b8t)\r1$\u000e\u001c\u0005\u0006W\u001e\u0004\raX\u0001\b[\u0016\u001c8/Y4f\u0011\u0015iw\r1\u0001`\u0003\u0019yW\u000f\u001e9vi\")q\u000e\u0001C\u0001a\u0006!\u0012m]:feR$u.Z:O_R\u001cuN\u001c;bS:$2AN9s\u0011\u0015Yg\u000e1\u0001`\u0011\u0015ig\u000e1\u0001`\u0001")
public class SingletonReplSuite
extends SparkFunSuite {
    private final StringWriter org$apache$spark$repl$SingletonReplSuite$$out = new StringWriter();
    private final PipedOutputStream in = new PipedOutputStream();
    private Thread thread;
    private final String CONF_EXECUTOR_CLASSPATH;
    private final String oldExecutorClasspath = System.getProperty(this.CONF_EXECUTOR_CLASSPATH());

    public StringWriter org$apache$spark$repl$SingletonReplSuite$$out() {
        return this.org$apache$spark$repl$SingletonReplSuite$$out;
    }

    private PipedOutputStream in() {
        return this.in;
    }

    private Thread thread() {
        return this.thread;
    }

    private void thread_$eq(Thread x$1) {
        this.thread = x$1;
    }

    private String CONF_EXECUTOR_CLASSPATH() {
        return this.CONF_EXECUTOR_CLASSPATH;
    }

    private String oldExecutorClasspath() {
        return this.oldExecutorClasspath;
    }

    public void beforeAll() {
        super.beforeAll();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ObjectRef paths = ObjectRef.create((Object)new ArrayBuffer());
        if (cl instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)cl;
            Predef$.MODULE$.refArrayOps((Object[])urlLoader.getURLs()).foreach((Function1)new Serializable(this, paths){
                public static final long serialVersionUID = 0L;
                private final ObjectRef paths$1;

                public final Object apply(URL url) {
                    String string = url.getProtocol();
                    String string2 = "file";
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ((ArrayBuffer)this.paths$1.elem).$plus$eq((Object)url.getFile()) : BoxedUnit.UNIT;
                }
                {
                    this.paths$1 = paths$1;
                }
            });
        }
        String classpath = ((TraversableOnce)((ArrayBuffer)paths.elem).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return new File(x$1).getAbsolutePath();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(File.pathSeparator);
        System.setProperty(this.CONF_EXECUTOR_CLASSPATH(), classpath);
        Main$.MODULE$.conf().set("spark.master", "local-cluster[2,1,1024]");
        SparkILoop interp = new SparkILoop(new BufferedReader(new InputStreamReader(new PipedInputStream(this.in()))), new PrintWriter(this.org$apache$spark$repl$SingletonReplSuite$$out()));
        Main$.MODULE$.sparkContext_$eq(null);
        Main$.MODULE$.sparkSession_$eq(null);
        this.thread_$eq(new Thread(new Runnable(this, classpath, interp){
            private final String classpath$1;
            private final SparkILoop interp$1;

            public void run() {
                Main$.MODULE$.doMain((String[])((Object[])new String[]{"-classpath", this.classpath$1}), this.interp$1);
            }
            {
                this.classpath$1 = classpath$1;
                this.interp$1 = interp$1;
            }
        }));
        this.thread().setDaemon(true);
        this.thread().start();
        this.waitUntil((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.org$apache$spark$repl$SingletonReplSuite$$out().toString().contains("Type :help for more information");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void afterAll() {
        this.in().close();
        this.thread().join();
        String string = this.oldExecutorClasspath() == null ? System.clearProperty(this.CONF_EXECUTOR_CLASSPATH()) : System.setProperty(this.CONF_EXECUTOR_CLASSPATH(), this.oldExecutorClasspath());
        super.afterAll();
    }

    private void waitUntil(Function0<Object> cond) {
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(500)).millis())), (Function0)new Serializable(this, cond){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;
            private final Function0 cond$1;

            public final Assertion apply() {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.cond$1.apply$mcZ$sp(), "cond.apply()", Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"current output: ").append((Object)this.$outer.org$apache$spark$repl$SingletonReplSuite$$out().toString()).toString(), Prettifier$.MODULE$.default(), new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cond$1 = cond$1;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
    }

    public String runInterpreter(String input) {
        int currentOffset = this.org$apache$spark$repl$SingletonReplSuite$$out().getBuffer().length();
        long timestamp = System.currentTimeMillis();
        this.in().write(new StringBuilder().append((Object)input).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nval _result_", " = 1\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp)}))).toString().getBytes());
        this.in().flush();
        String stopMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_result_", ": Int = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp)}));
        this.waitUntil((Function0<Object>)new Serializable(this, currentOffset, stopMessage){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;
            private final int currentOffset$1;
            private final String stopMessage$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.org$apache$spark$repl$SingletonReplSuite$$out().getBuffer().substring(this.currentOffset$1).contains(this.stopMessage$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentOffset$1 = currentOffset$1;
                this.stopMessage$1 = stopMessage$1;
            }
        });
        return this.org$apache$spark$repl$SingletonReplSuite$$out().getBuffer().substring(currentOffset);
    }

    public void assertContains(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"Interpreter output did not contain '").append((Object)message).append((Object)"':\n").append((Object)output).toString(), Prettifier$.MODULE$.default(), new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }

    public void assertDoesNotContain(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"Interpreter output contained '").append((Object)message).append((Object)"':\n").append((Object)output).toString(), Prettifier$.MODULE$.default(), new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }

    public SingletonReplSuite() {
        this.CONF_EXECUTOR_CLASSPATH = "spark.executor.extraClassPath";
        this.test("simple foreach with accumulator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |val accum = sc.longAccumulator\n        |sc.parallelize(1 to 10).foreach(x => accum.add(x))\n        |val res = accum.value\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res: Long = 55", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("external vars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |var v = 7\n        |val res1 = sc.parallelize(1 to 10).map(x => v).collect().reduceLeft(_+_)\n        |v = 10\n        |val res2 = sc.parallelize(1 to 10).map(x => v).collect().reduceLeft(_+_)\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res1: Int = 70", output);
                this.$outer.assertContains("res2: Int = 100", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("external classes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |class C {\n        |def foo = 5\n        |}\n        |val res = sc.parallelize(1 to 10).map(x => (new C).foo).collect().reduceLeft(_+_)\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res: Int = 50", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("external functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |def double(x: Int) = x + x\n        |val res = sc.parallelize(1 to 10).map(x => double(x)).collect().reduceLeft(_+_)\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res: Int = 110", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("external functions that access vars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |var v = 7\n        |def getV() = v\n        |val res1 = sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n        |v = 10\n        |val res2 = sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res1: Int = 70", output);
                this.$outer.assertContains("res2: Int = 100", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("broadcast vars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |var array = new Array[Int](5)\n        |val broadcastArray = sc.broadcast(array)\n        |val res1 = sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        |array(0) = 5\n        |val res2 = sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res1: Array[Int] = Array(0, 0, 0, 0, 0)", output);
                this.$outer.assertContains("res2: Array[Int] = Array(0, 0, 0, 0, 0)", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("interacting with files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                FileWriter out = new FileWriter(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tempDir), "/input"));
                out.write("Hello world!\n");
                out.write("What's up?\n");
                out.write("Goodbye\n");
                out.close();
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("\n        |var file = sc.textFile(\"%s\").cache()\n        |val res1 = file.count()\n        |val res2 = file.count()\n        |val res3 = file.count()\n      ")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{StringEscapeUtils.escapeJava((String)new StringBuilder().append((Object)tempDir.getAbsolutePath()).append((Object)File.separator).append((Object)"input").toString())})));
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res1: Long = 3", output);
                this.$outer.assertContains("res2: Long = 3", output);
                this.$outer.assertContains("res3: Long = 3", output);
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        this.test("local-cluster mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |var v = 7\n        |def getV() = v\n        |val res1 = sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n        |v = 10\n        |val res2 = sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n        |var array = new Array[Int](5)\n        |val broadcastArray = sc.broadcast(array)\n        |val res3 = sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        |array(0) = 5\n        |val res4 = sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res1: Int = 70", output);
                this.$outer.assertContains("res2: Int = 100", output);
                this.$outer.assertContains("res3: Array[Int] = Array(0, 0, 0, 0, 0)", output);
                this.$outer.assertContains("res4: Array[Int] = Array(0, 0, 0, 0, 0)", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("SPARK-1199 two instances of same class don't type check.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |case class Sum(exp: String, exp2: String)\n        |val a = Sum(\"A\", \"B\")\n        |def b(a: Sum): String = a match { case Sum(_, _) => \"Found Sum\" }\n        |b(a)\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        this.test("SPARK-2452 compound statements.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |val x = 4 ; def f() = x\n        |f()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        this.test("SPARK-2576 importing implicits", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |import spark.implicits._\n        |case class TestCaseClass(value: Int)\n        |sc.parallelize(1 to 10).map(x => TestCaseClass(x)).toDF().collect()\n        |\n        |// Test Dataset Serialization in the REPL\n        |Seq(TestCaseClass(1)).toDS().collect()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("Datasets and encoders", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.sql.functions._\n        |import org.apache.spark.sql.{Encoder, Encoders}\n        |import org.apache.spark.sql.expressions.Aggregator\n        |import org.apache.spark.sql.TypedColumn\n        |val simpleSum = new Aggregator[Int, Int, Int] {\n        |  def zero: Int = 0                     // The initial value.\n        |  def reduce(b: Int, a: Int) = b + a    // Add an element to the running total\n        |  def merge(b1: Int, b2: Int) = b1 + b2 // Merge intermediate values.\n        |  def finish(b: Int) = b                // Return the final result.\n        |  def bufferEncoder: Encoder[Int] = Encoders.scalaInt\n        |  def outputEncoder: Encoder[Int] = Encoders.scalaInt\n        |}.toColumn\n        |\n        |val ds = Seq(1, 2, 3, 4).toDS()\n        |ds.select(simpleSum).collect\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("SPARK-2632 importing a method from non serializable class and not using it.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |class TestClass() { def testMethod = 3 }\n        |val t = new TestClass\n        |import t.testMethod\n        |case class TestCaseClass(value: Int)\n        |sc.parallelize(1 to 10).map(x => TestCaseClass(x)).collect()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        this.test("collecting objects of class defined in repl", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |case class Foo(i: Int)\n        |val res = sc.parallelize((1 to 100).map(Foo), 10).collect()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res: Array[Foo] = Array(Foo(1),", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.test("collecting objects of class defined in repl - shuffling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |case class Foo(i: Int)\n        |val list = List((1, Foo(1)), (1, Foo(2)))\n        |val res = sc.parallelize(list).groupByKey().collect()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res: Array[(Int, Iterable[Foo])] = Array((1,", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("replicating blocks of object with class defined in repl", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |val timeout = 60000 // 60 seconds\n        |val start = System.currentTimeMillis\n        |while(sc.statusTracker.getExecutorInfos.size != 3 &&\n        |    (System.currentTimeMillis - start) < timeout) {\n        |  Thread.sleep(10)\n        |}\n        |if (System.currentTimeMillis - start >= timeout) {\n        |  throw new java.util.concurrent.TimeoutException(\"Executors were not up in 60 seconds\")\n        |}\n        |import org.apache.spark.storage.StorageLevel._\n        |case class Foo(i: Int)\n        |val ret = sc.parallelize((1 to 100).map(Foo), 10).persist(MEMORY_AND_DISK_2)\n        |ret.count()\n        |val res = sc.getRDDStorageInfo.filter(_.id == ret.id).map(_.numCachedPartitions).sum\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res: Int = 10", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        this.test("should clone and clean line object in ClosureCleaner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.rdd.RDD\n        |\n        |val lines = sc.textFile(\"pom.xml\")\n        |case class Data(s: String)\n        |val dataRDD = lines.map(line => Data(line.take(3)))\n        |dataRDD.cache.count\n        |val repartitioned = dataRDD.repartition(dataRDD.partitions.size)\n        |repartitioned.cache.count\n        |\n        |def getCacheSize(rdd: RDD[_]) = {\n        |  sc.getRDDStorageInfo.filter(_.id == rdd.id).map(_.memSize).sum\n        |}\n        |val cacheSize1 = getCacheSize(dataRDD)\n        |val cacheSize2 = getCacheSize(repartitioned)\n        |\n        |// The cache size of dataRDD and the repartitioned one should be similar.\n        |val deviation = math.abs(cacheSize2 - cacheSize1).toDouble / cacheSize1\n        |assert(deviation < 0.2,\n        |  s\"deviation too large: $deviation, first size: $cacheSize1, second size: $cacheSize2\")\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("AssertionError", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        this.test("newProductSeqEncoder with REPL defined class", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SingletonReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |case class Click(id: Int)\n        |spark.implicits.newProductSeqEncoder[Click]\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("SingletonReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
    }
}

