/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text;

import com.azure.ai.translation.text.CustomEndpointUtils;
import com.azure.ai.translation.text.TextTranslationAsyncClient;
import com.azure.ai.translation.text.TextTranslationClient;
import com.azure.ai.translation.text.TextTranslationServiceVersion;
import com.azure.ai.translation.text.implementation.TextTranslationClientImpl;
import com.azure.ai.translation.text.models.TextTranslationAudience;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.KeyCredentialTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.KeyCredentialPolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={TextTranslationClient.class, TextTranslationAsyncClient.class})
public final class TextTranslationClientBuilder
implements HttpTrait<TextTranslationClientBuilder>,
ConfigurationTrait<TextTranslationClientBuilder>,
EndpointTrait<TextTranslationClientBuilder>,
KeyCredentialTrait<TextTranslationClientBuilder>,
TokenCredentialTrait<TextTranslationClientBuilder> {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String DEFAULT_SCOPE = "/.default";
    private static final String OCP_APIM_SUBSCRIPTION_KEY = "Ocp-Apim-Subscription-Key";
    private static final String OCP_APIM_SUBSCRIPTION_REGION = "Ocp-Apim-Subscription-Region";
    private static final String OCP_APIM_RESOURCE_ID_KEY = "Ocp-Apim-ResourceId";
    private String region;
    private String resourceId;
    private TextTranslationAudience audience;
    private KeyCredential credential;
    private TokenCredential tokenCredential;
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-ai-translation-text.properties");
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private String endpoint;
    private Boolean isCustomEndpoint = false;
    private TextTranslationServiceVersion serviceVersion;
    private RetryPolicy retryPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(TextTranslationClientBuilder.class);

    public TextTranslationClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.atInfo().log("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public TextTranslationClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public TextTranslationClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public TextTranslationClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public TextTranslationClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public TextTranslationClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null.");
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public TextTranslationClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public TextTranslationClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        this.isCustomEndpoint = CustomEndpointUtils.isPlatformHost(endpoint);
        return this;
    }

    public TextTranslationClientBuilder serviceVersion(TextTranslationServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public TextTranslationClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public TextTranslationClientBuilder credential(KeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credential = credential;
        return this;
    }

    public TextTranslationClientBuilder region(String region) {
        Objects.requireNonNull(region, "'region' cannot be null.");
        this.region = region;
        return this;
    }

    public TextTranslationClientBuilder resourceId(String resourceId) {
        Objects.requireNonNull(resourceId, "'resourceId' cannot be null.");
        this.resourceId = resourceId;
        return this;
    }

    public TextTranslationClientBuilder audience(TextTranslationAudience audience) {
        Objects.requireNonNull(audience, "'audience' cannot be null.");
        this.audience = audience;
        return this;
    }

    public TextTranslationClientBuilder credential(TokenCredential tokenCredential) {
        Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        this.tokenCredential = tokenCredential;
        return this;
    }

    private TextTranslationClientImpl buildInnerClient() {
        String serviceEndpoint;
        TextTranslationServiceVersion localServiceVersion;
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : this.createHttpPipeline();
        TextTranslationServiceVersion textTranslationServiceVersion = localServiceVersion = this.serviceVersion != null ? this.serviceVersion : TextTranslationServiceVersion.getLatest();
        if (this.endpoint == null) {
            serviceEndpoint = "https://api.cognitive.microsofttranslator.com";
        } else if (this.isCustomEndpoint.booleanValue()) {
            try {
                URL hostUri = new URL(this.endpoint);
                URL fullUri = new URL(hostUri, "/translator/text/v" + localServiceVersion.getVersion());
                serviceEndpoint = fullUri.toString();
            }
            catch (MalformedURLException ex) {
                serviceEndpoint = this.endpoint;
            }
        } else {
            serviceEndpoint = this.endpoint;
        }
        if (this.tokenCredential != null && (this.region != null || this.resourceId != null)) {
            Objects.requireNonNull(this.region, "'region' cannot be null.");
            Objects.requireNonNull(this.resourceId, "'resourceId' cannot be null.");
        }
        if (this.credential != null && !CoreUtils.isNullOrEmpty((CharSequence)this.resourceId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Resource Id cannot be used with key credential. Set resourceId to null."));
        }
        if (this.tokenCredential != null && this.credential != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Both token credential and key credential cannot be set."));
        }
        TextTranslationClientImpl client = new TextTranslationClientImpl(localPipeline, JacksonAdapter.createDefaultSerializerAdapter(), serviceEndpoint, localServiceVersion);
        return client;
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        HttpLogOptions localHttpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)localHttpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        HttpHeaders headers = new HttpHeaders();
        localClientOptions.getHeaders().forEach(header -> headers.set(HttpHeaderName.fromString((String)header.getName()), header.getValue()));
        if (headers.getSize() > 0) {
            policies.add(new AddHeadersPolicy(headers));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).forEach(p -> policies.add(p));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add(new AddDatePolicy());
        if (this.tokenCredential != null) {
            TextTranslationAudience authAudience = TextTranslationAudience.AZURE_PUBLIC_CLOUD;
            if (this.audience != null) {
                authAudience = this.audience;
            }
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{(Object)((Object)authAudience) + DEFAULT_SCOPE}));
            if (this.region != null || this.resourceId != null) {
                HttpHeaders aadHeaders = new HttpHeaders();
                aadHeaders.put(OCP_APIM_RESOURCE_ID_KEY, this.resourceId);
                aadHeaders.put(OCP_APIM_SUBSCRIPTION_REGION, this.region);
                policies.add(new AddHeadersPolicy(aadHeaders));
            }
        }
        if (this.credential != null) {
            policies.add(new KeyCredentialPolicy(OCP_APIM_SUBSCRIPTION_KEY, this.credential));
            if (this.region != null) {
                HttpHeaders regionHeaders = new HttpHeaders();
                regionHeaders.put(OCP_APIM_SUBSCRIPTION_REGION, this.region);
                policies.add(new AddHeadersPolicy(regionHeaders));
            }
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).forEach(p -> policies.add(p));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(localHttpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).build();
        return httpPipeline;
    }

    public TextTranslationAsyncClient buildAsyncClient() {
        return new TextTranslationAsyncClient(this.buildInnerClient());
    }

    public TextTranslationClient buildClient() {
        return new TextTranslationClient(this.buildInnerClient());
    }

    private void validateClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
    }
}

