/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BackTranslation
implements JsonSerializable<BackTranslation> {
    private final String normalizedText;
    private final String displayText;
    private final int examplesCount;
    private final int frequencyCount;

    private BackTranslation(String normalizedText, String displayText, int examplesCount, int frequencyCount) {
        this.normalizedText = normalizedText;
        this.displayText = displayText;
        this.examplesCount = examplesCount;
        this.frequencyCount = frequencyCount;
    }

    public String getNormalizedText() {
        return this.normalizedText;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public int getExamplesCount() {
        return this.examplesCount;
    }

    public int getFrequencyCount() {
        return this.frequencyCount;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("normalizedText", this.normalizedText);
        jsonWriter.writeStringField("displayText", this.displayText);
        jsonWriter.writeIntField("numExamples", this.examplesCount);
        jsonWriter.writeIntField("frequencyCount", this.frequencyCount);
        return jsonWriter.writeEndObject();
    }

    public static BackTranslation fromJson(JsonReader jsonReader) throws IOException {
        return (BackTranslation)jsonReader.readObject(reader -> {
            String normalizedText = null;
            String displayText = null;
            int examplesCount = 0;
            int frequencyCount = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("normalizedText".equals(fieldName)) {
                    normalizedText = reader.getString();
                    continue;
                }
                if ("displayText".equals(fieldName)) {
                    displayText = reader.getString();
                    continue;
                }
                if ("numExamples".equals(fieldName)) {
                    examplesCount = reader.getInt();
                    continue;
                }
                if ("frequencyCount".equals(fieldName)) {
                    frequencyCount = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new BackTranslation(normalizedText, displayText, examplesCount, frequencyCount);
        });
    }
}

