/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.DictionaryExample;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DictionaryExampleItem
implements JsonSerializable<DictionaryExampleItem> {
    private final String normalizedSource;
    private final String normalizedTarget;
    private final List<DictionaryExample> examples;

    private DictionaryExampleItem(String normalizedSource, String normalizedTarget, List<DictionaryExample> examples) {
        this.normalizedSource = normalizedSource;
        this.normalizedTarget = normalizedTarget;
        this.examples = examples;
    }

    public String getNormalizedSource() {
        return this.normalizedSource;
    }

    public String getNormalizedTarget() {
        return this.normalizedTarget;
    }

    public List<DictionaryExample> getExamples() {
        return this.examples;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("normalizedSource", this.normalizedSource);
        jsonWriter.writeStringField("normalizedTarget", this.normalizedTarget);
        jsonWriter.writeArrayField("examples", this.examples, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DictionaryExampleItem fromJson(JsonReader jsonReader) throws IOException {
        return (DictionaryExampleItem)jsonReader.readObject(reader -> {
            String normalizedSource = null;
            String normalizedTarget = null;
            List examples = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("normalizedSource".equals(fieldName)) {
                    normalizedSource = reader.getString();
                    continue;
                }
                if ("normalizedTarget".equals(fieldName)) {
                    normalizedTarget = reader.getString();
                    continue;
                }
                if ("examples".equals(fieldName)) {
                    examples = reader.readArray(reader1 -> DictionaryExample.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new DictionaryExampleItem(normalizedSource, normalizedTarget, examples);
        });
    }
}

