/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.InputTextItem;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DictionaryExampleTextItem
extends InputTextItem {
    private final String translation;

    public DictionaryExampleTextItem(String text, String translation) {
        super(text);
        this.translation = translation;
    }

    public String getTranslation() {
        return this.translation;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.getText());
        jsonWriter.writeStringField("translation", this.translation);
        return jsonWriter.writeEndObject();
    }

    public static DictionaryExampleTextItem fromJson(JsonReader jsonReader) throws IOException {
        return (DictionaryExampleTextItem)jsonReader.readObject(reader -> {
            String text = null;
            String translation = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("translation".equals(fieldName)) {
                    translation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new DictionaryExampleTextItem(text, translation);
        });
    }
}

