/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.DictionaryTranslation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DictionaryLookupItem
implements JsonSerializable<DictionaryLookupItem> {
    private final String normalizedSource;
    private final String displaySource;
    private final List<DictionaryTranslation> translations;

    private DictionaryLookupItem(String normalizedSource, String displaySource, List<DictionaryTranslation> translations) {
        this.normalizedSource = normalizedSource;
        this.displaySource = displaySource;
        this.translations = translations;
    }

    public String getNormalizedSource() {
        return this.normalizedSource;
    }

    public String getDisplaySource() {
        return this.displaySource;
    }

    public List<DictionaryTranslation> getTranslations() {
        return this.translations;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("normalizedSource", this.normalizedSource);
        jsonWriter.writeStringField("displaySource", this.displaySource);
        jsonWriter.writeArrayField("translations", this.translations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DictionaryLookupItem fromJson(JsonReader jsonReader) throws IOException {
        return (DictionaryLookupItem)jsonReader.readObject(reader -> {
            String normalizedSource = null;
            String displaySource = null;
            List translations = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("normalizedSource".equals(fieldName)) {
                    normalizedSource = reader.getString();
                    continue;
                }
                if ("displaySource".equals(fieldName)) {
                    displaySource = reader.getString();
                    continue;
                }
                if ("translations".equals(fieldName)) {
                    translations = reader.readArray(reader1 -> DictionaryTranslation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new DictionaryLookupItem(normalizedSource, displaySource, translations);
        });
    }
}

