/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.BackTranslation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DictionaryTranslation
implements JsonSerializable<DictionaryTranslation> {
    private final String normalizedTarget;
    private final String displayTarget;
    private final String posTag;
    private final double confidence;
    private final String prefixWord;
    private final List<BackTranslation> backTranslations;

    private DictionaryTranslation(String normalizedTarget, String displayTarget, String posTag, double confidence, String prefixWord, List<BackTranslation> backTranslations) {
        this.normalizedTarget = normalizedTarget;
        this.displayTarget = displayTarget;
        this.posTag = posTag;
        this.confidence = confidence;
        this.prefixWord = prefixWord;
        this.backTranslations = backTranslations;
    }

    public String getNormalizedTarget() {
        return this.normalizedTarget;
    }

    public String getDisplayTarget() {
        return this.displayTarget;
    }

    public String getPosTag() {
        return this.posTag;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String getPrefixWord() {
        return this.prefixWord;
    }

    public List<BackTranslation> getBackTranslations() {
        return this.backTranslations;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("normalizedTarget", this.normalizedTarget);
        jsonWriter.writeStringField("displayTarget", this.displayTarget);
        jsonWriter.writeStringField("posTag", this.posTag);
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeStringField("prefixWord", this.prefixWord);
        jsonWriter.writeArrayField("backTranslations", this.backTranslations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DictionaryTranslation fromJson(JsonReader jsonReader) throws IOException {
        return (DictionaryTranslation)jsonReader.readObject(reader -> {
            String normalizedTarget = null;
            String displayTarget = null;
            String posTag = null;
            double confidence = 0.0;
            String prefixWord = null;
            List backTranslations = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("normalizedTarget".equals(fieldName)) {
                    normalizedTarget = reader.getString();
                    continue;
                }
                if ("displayTarget".equals(fieldName)) {
                    displayTarget = reader.getString();
                    continue;
                }
                if ("posTag".equals(fieldName)) {
                    posTag = reader.getString();
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("prefixWord".equals(fieldName)) {
                    prefixWord = reader.getString();
                    continue;
                }
                if ("backTranslations".equals(fieldName)) {
                    backTranslations = reader.readArray(reader1 -> BackTranslation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new DictionaryTranslation(normalizedTarget, displayTarget, posTag, confidence, prefixWord, backTranslations);
        });
    }
}

