/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.SourceDictionaryLanguage;
import com.azure.ai.translation.text.models.TranslationLanguage;
import com.azure.ai.translation.text.models.TransliterationLanguage;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class GetSupportedLanguagesResult
implements JsonSerializable<GetSupportedLanguagesResult> {
    private Map<String, TranslationLanguage> translation;
    private Map<String, TransliterationLanguage> transliteration;
    private Map<String, SourceDictionaryLanguage> dictionary;

    private GetSupportedLanguagesResult() {
    }

    public Map<String, TranslationLanguage> getTranslation() {
        return this.translation;
    }

    public Map<String, TransliterationLanguage> getTransliteration() {
        return this.transliteration;
    }

    public Map<String, SourceDictionaryLanguage> getDictionary() {
        return this.dictionary;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("translation", this.translation, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("transliteration", this.transliteration, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("dictionary", this.dictionary, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GetSupportedLanguagesResult fromJson(JsonReader jsonReader) throws IOException {
        return (GetSupportedLanguagesResult)jsonReader.readObject(reader -> {
            GetSupportedLanguagesResult deserializedGetSupportedLanguagesResult = new GetSupportedLanguagesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("translation".equals(fieldName)) {
                    Map translation;
                    deserializedGetSupportedLanguagesResult.translation = translation = reader.readMap(reader1 -> TranslationLanguage.fromJson(reader1));
                    continue;
                }
                if ("transliteration".equals(fieldName)) {
                    Map transliteration;
                    deserializedGetSupportedLanguagesResult.transliteration = transliteration = reader.readMap(reader1 -> TransliterationLanguage.fromJson(reader1));
                    continue;
                }
                if ("dictionary".equals(fieldName)) {
                    Map dictionary;
                    deserializedGetSupportedLanguagesResult.dictionary = dictionary = reader.readMap(reader1 -> SourceDictionaryLanguage.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetSupportedLanguagesResult;
        });
    }
}

