/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.LanguageDirectionality;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class LanguageScript
implements JsonSerializable<LanguageScript> {
    private final String code;
    private final String name;
    private final String nativeName;
    private final LanguageDirectionality directionality;

    protected LanguageScript(String code, String name, String nativeName, LanguageDirectionality directionality) {
        this.code = code;
        this.name = name;
        this.nativeName = nativeName;
        this.directionality = directionality;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public LanguageDirectionality getDirectionality() {
        return this.directionality;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("nativeName", this.nativeName);
        jsonWriter.writeStringField("dir", this.directionality == null ? null : this.directionality.toString());
        return jsonWriter.writeEndObject();
    }

    public static LanguageScript fromJson(JsonReader jsonReader) throws IOException {
        return (LanguageScript)jsonReader.readObject(reader -> {
            String code = null;
            String name = null;
            String nativeName = null;
            LanguageDirectionality directionality = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("nativeName".equals(fieldName)) {
                    nativeName = reader.getString();
                    continue;
                }
                if ("dir".equals(fieldName)) {
                    directionality = LanguageDirectionality.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new LanguageScript(code, name, nativeName, directionality);
        });
    }
}

