/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SentenceBoundaries
implements JsonSerializable<SentenceBoundaries> {
    private final List<Integer> sourceSentencesLengths;
    private final List<Integer> translatedSentencesLengths;

    private SentenceBoundaries(List<Integer> sourceSentencesLengths, List<Integer> translatedSentencesLengths) {
        this.sourceSentencesLengths = sourceSentencesLengths;
        this.translatedSentencesLengths = translatedSentencesLengths;
    }

    public List<Integer> getSourceSentencesLengths() {
        return this.sourceSentencesLengths;
    }

    public List<Integer> getTranslatedSentencesLengths() {
        return this.translatedSentencesLengths;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("srcSentLen", this.sourceSentencesLengths, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("transSentLen", this.translatedSentencesLengths, (writer, element) -> writer.writeInt(element.intValue()));
        return jsonWriter.writeEndObject();
    }

    public static SentenceBoundaries fromJson(JsonReader jsonReader) throws IOException {
        return (SentenceBoundaries)jsonReader.readObject(reader -> {
            List sourceSentencesLengths = null;
            List translatedSentencesLengths = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("srcSentLen".equals(fieldName)) {
                    sourceSentencesLengths = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("transSentLen".equals(fieldName)) {
                    translatedSentencesLengths = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                reader.skipChildren();
            }
            return new SentenceBoundaries(sourceSentencesLengths, translatedSentencesLengths);
        });
    }
}

