/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.DetectedLanguage;
import com.azure.ai.translation.text.models.SourceText;
import com.azure.ai.translation.text.models.TranslationText;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TranslatedTextItem
implements JsonSerializable<TranslatedTextItem> {
    private DetectedLanguage detectedLanguage;
    private final List<TranslationText> translations;
    private SourceText sourceText;

    private TranslatedTextItem(List<TranslationText> translations) {
        this.translations = translations;
    }

    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    public List<TranslationText> getTranslations() {
        return this.translations;
    }

    public SourceText getSourceText() {
        return this.sourceText;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("translations", this.translations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("detectedLanguage", (JsonSerializable)this.detectedLanguage);
        jsonWriter.writeJsonField("sourceText", (JsonSerializable)this.sourceText);
        return jsonWriter.writeEndObject();
    }

    public static TranslatedTextItem fromJson(JsonReader jsonReader) throws IOException {
        return (TranslatedTextItem)jsonReader.readObject(reader -> {
            List translations = null;
            DetectedLanguage detectedLanguage = null;
            SourceText sourceText = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("translations".equals(fieldName)) {
                    translations = reader.readArray(reader1 -> TranslationText.fromJson(reader1));
                    continue;
                }
                if ("detectedLanguage".equals(fieldName)) {
                    detectedLanguage = DetectedLanguage.fromJson(reader);
                    continue;
                }
                if ("sourceText".equals(fieldName)) {
                    sourceText = SourceText.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            TranslatedTextItem deserializedTranslatedTextItem = new TranslatedTextItem(translations);
            deserializedTranslatedTextItem.detectedLanguage = detectedLanguage;
            deserializedTranslatedTextItem.sourceText = sourceText;
            return deserializedTranslatedTextItem;
        });
    }
}

