/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.LanguageDirectionality;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TranslationLanguage
implements JsonSerializable<TranslationLanguage> {
    private final String name;
    private final String nativeName;
    private final LanguageDirectionality directionality;

    private TranslationLanguage(String name, String nativeName, LanguageDirectionality directionality) {
        this.name = name;
        this.nativeName = nativeName;
        this.directionality = directionality;
    }

    public String getName() {
        return this.name;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public LanguageDirectionality getDirectionality() {
        return this.directionality;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("nativeName", this.nativeName);
        jsonWriter.writeStringField("dir", this.directionality == null ? null : this.directionality.toString());
        return jsonWriter.writeEndObject();
    }

    public static TranslationLanguage fromJson(JsonReader jsonReader) throws IOException {
        return (TranslationLanguage)jsonReader.readObject(reader -> {
            String name = null;
            String nativeName = null;
            LanguageDirectionality directionality = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("nativeName".equals(fieldName)) {
                    nativeName = reader.getString();
                    continue;
                }
                if ("dir".equals(fieldName)) {
                    directionality = LanguageDirectionality.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new TranslationLanguage(name, nativeName, directionality);
        });
    }
}

