/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.LanguageDirectionality;
import com.azure.ai.translation.text.models.LanguageScript;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TransliterableScript
extends LanguageScript {
    private final List<LanguageScript> targetLanguageScripts;

    private TransliterableScript(String code, String name, String nativeName, LanguageDirectionality directionality, List<LanguageScript> targetLanguageScripts) {
        super(code, name, nativeName, directionality);
        this.targetLanguageScripts = targetLanguageScripts;
    }

    public List<LanguageScript> getTargetLanguageScripts() {
        return this.targetLanguageScripts;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.getCode());
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("nativeName", this.getNativeName());
        jsonWriter.writeStringField("dir", this.getDirectionality() == null ? null : this.getDirectionality().toString());
        jsonWriter.writeArrayField("toScripts", this.targetLanguageScripts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TransliterableScript fromJson(JsonReader jsonReader) throws IOException {
        return (TransliterableScript)jsonReader.readObject(reader -> {
            String code = null;
            String name = null;
            String nativeName = null;
            LanguageDirectionality directionality = null;
            List targetLanguageScripts = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("nativeName".equals(fieldName)) {
                    nativeName = reader.getString();
                    continue;
                }
                if ("dir".equals(fieldName)) {
                    directionality = LanguageDirectionality.fromString(reader.getString());
                    continue;
                }
                if ("toScripts".equals(fieldName)) {
                    targetLanguageScripts = reader.readArray(reader1 -> LanguageScript.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new TransliterableScript(code, name, nativeName, directionality, targetLanguageScripts);
        });
    }
}

