/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.translation.text.models;

import com.azure.ai.translation.text.models.TransliterableScript;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TransliterationLanguage
implements JsonSerializable<TransliterationLanguage> {
    private final String name;
    private final String nativeName;
    private final List<TransliterableScript> scripts;

    private TransliterationLanguage(String name, String nativeName, List<TransliterableScript> scripts) {
        this.name = name;
        this.nativeName = nativeName;
        this.scripts = scripts;
    }

    public String getName() {
        return this.name;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public List<TransliterableScript> getScripts() {
        return this.scripts;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("nativeName", this.nativeName);
        jsonWriter.writeArrayField("scripts", this.scripts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TransliterationLanguage fromJson(JsonReader jsonReader) throws IOException {
        return (TransliterationLanguage)jsonReader.readObject(reader -> {
            String name = null;
            String nativeName = null;
            List scripts = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("nativeName".equals(fieldName)) {
                    nativeName = reader.getString();
                    continue;
                }
                if ("scripts".equals(fieldName)) {
                    scripts = reader.readArray(reader1 -> TransliterableScript.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new TransliterationLanguage(name, nativeName, scripts);
        });
    }
}

