/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.jdbc.mysql;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.extensions.implementation.template.AzureAuthenticationTemplate;
import com.mysql.cj.callback.MysqlCallbackHandler;
import com.mysql.cj.protocol.AuthenticationPlugin;
import com.mysql.cj.protocol.Protocol;
import com.mysql.cj.protocol.a.NativeConstants;
import com.mysql.cj.protocol.a.NativePacketPayload;
import java.util.List;
import java.util.Properties;

public class AzureMysqlAuthenticationPlugin
implements AuthenticationPlugin<NativePacketPayload> {
    private static final ClientLogger LOGGER = new ClientLogger(AzureMysqlAuthenticationPlugin.class);
    private static final String PLUGIN_NAME = "mysql_clear_password";
    private final AzureAuthenticationTemplate azureAuthenticationTemplate;
    private Protocol<NativePacketPayload> protocol;

    public AzureMysqlAuthenticationPlugin() {
        this(new AzureAuthenticationTemplate());
    }

    AzureMysqlAuthenticationPlugin(AzureAuthenticationTemplate azureAuthenticationTemplate) {
        this.azureAuthenticationTemplate = azureAuthenticationTemplate;
    }

    AzureMysqlAuthenticationPlugin(AzureAuthenticationTemplate azureAuthenticationTemplate, Protocol<NativePacketPayload> protocol) {
        this.azureAuthenticationTemplate = azureAuthenticationTemplate;
        this.protocol = protocol;
    }

    public void destroy() {
    }

    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    public void init(Protocol<NativePacketPayload> protocol) {
        this.protocol = protocol;
        Properties properties = protocol.getPropertySet().exposeAsProperties();
        this.azureAuthenticationTemplate.init(properties);
    }

    public void init(Protocol<NativePacketPayload> protocol, MysqlCallbackHandler callbackHandler) {
        this.init(protocol);
    }

    public boolean isReusable() {
        return true;
    }

    public boolean nextAuthenticationStep(NativePacketPayload fromServer, List<NativePacketPayload> toServer) {
        NativePacketPayload response;
        toServer.clear();
        if (fromServer == null) {
            response = new NativePacketPayload(new byte[0]);
        } else if (this.protocol.getSocketConnection().isSSLEstablished()) {
            try {
                String password = this.azureAuthenticationTemplate.getTokenAsPassword();
                byte[] content = password.getBytes(this.protocol.getServerSession().getCharsetSettings().getPasswordCharacterEncoding());
                response = new NativePacketPayload(content);
                response.setPosition(response.getPayloadLength());
                response.writeInteger(NativeConstants.IntegerDataType.INT1, 0L);
                response.setPosition(0);
            }
            catch (Exception uee) {
                LOGGER.error(uee.getMessage(), new Object[]{uee});
                response = new NativePacketPayload(new byte[0]);
            }
        } else {
            response = new NativePacketPayload(new byte[0]);
        }
        toServer.add(response);
        return true;
    }

    public boolean requiresConfidentiality() {
        return true;
    }

    public void setAuthenticationParameters(String username, String password) {
    }
}

