/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.IssuerParameters;
import com.azure.security.keyvault.certificates.models.CertificateOperationError;
import java.io.IOException;

public final class CertificateOperation
implements JsonSerializable<CertificateOperation> {
    private String id;
    private IssuerParameters issuerParameters;
    private byte[] csr;
    private Boolean cancellationRequested;
    private String status;
    private String statusDetails;
    private CertificateOperationError error;
    private String target;
    private Boolean preserveCertOrder;
    private String requestId;

    public String getId() {
        return this.id;
    }

    public IssuerParameters getIssuerParameters() {
        return this.issuerParameters;
    }

    public CertificateOperation setIssuerParameters(IssuerParameters issuerParameters) {
        this.issuerParameters = issuerParameters;
        return this;
    }

    public byte[] getCsr() {
        return CoreUtils.clone((byte[])this.csr);
    }

    public CertificateOperation setCsr(byte[] csr) {
        this.csr = CoreUtils.clone((byte[])csr);
        return this;
    }

    public Boolean isCancellationRequested() {
        return this.cancellationRequested;
    }

    public CertificateOperation setCancellationRequested(Boolean cancellationRequested) {
        this.cancellationRequested = cancellationRequested;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public CertificateOperation setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public CertificateOperation setStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    public CertificateOperationError getError() {
        return this.error;
    }

    public CertificateOperation setError(CertificateOperationError error) {
        this.error = error;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public CertificateOperation setTarget(String target) {
        this.target = target;
        return this;
    }

    public Boolean isPreserveCertOrder() {
        return this.preserveCertOrder;
    }

    public CertificateOperation setPreserveCertOrder(Boolean preserveCertOrder) {
        this.preserveCertOrder = preserveCertOrder;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public CertificateOperation setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("issuer", (JsonSerializable)this.issuerParameters);
        jsonWriter.writeBinaryField("csr", this.csr);
        jsonWriter.writeBooleanField("cancellation_requested", this.cancellationRequested);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("status_details", this.statusDetails);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeBooleanField("preserveCertOrder", this.preserveCertOrder);
        jsonWriter.writeStringField("request_id", this.requestId);
        return jsonWriter.writeEndObject();
    }

    public static CertificateOperation fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateOperation)jsonReader.readObject(reader -> {
            CertificateOperation deserializedCertificateOperation = new CertificateOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificateOperation.id = reader.getString();
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedCertificateOperation.issuerParameters = IssuerParameters.fromJson(reader);
                    continue;
                }
                if ("csr".equals(fieldName)) {
                    deserializedCertificateOperation.csr = reader.getBinary();
                    continue;
                }
                if ("cancellation_requested".equals(fieldName)) {
                    deserializedCertificateOperation.cancellationRequested = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedCertificateOperation.status = reader.getString();
                    continue;
                }
                if ("status_details".equals(fieldName)) {
                    deserializedCertificateOperation.statusDetails = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedCertificateOperation.error = CertificateOperationError.fromJson(reader);
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedCertificateOperation.target = reader.getString();
                    continue;
                }
                if ("preserveCertOrder".equals(fieldName)) {
                    deserializedCertificateOperation.preserveCertOrder = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("request_id".equals(fieldName)) {
                    deserializedCertificateOperation.requestId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateOperation;
        });
    }
}

