/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.IssuerParameters;
import com.azure.security.keyvault.certificates.implementation.models.KeyProperties;
import com.azure.security.keyvault.certificates.implementation.models.LifetimeAction;
import com.azure.security.keyvault.certificates.implementation.models.SecretProperties;
import com.azure.security.keyvault.certificates.implementation.models.X509CertificateProperties;
import java.io.IOException;
import java.util.List;

public final class CertificatePolicy
implements JsonSerializable<CertificatePolicy> {
    private String id;
    private KeyProperties keyProperties;
    private SecretProperties secretProperties;
    private X509CertificateProperties x509CertificateProperties;
    private List<LifetimeAction> lifetimeActions;
    private IssuerParameters issuerParameters;
    private CertificateAttributes attributes;

    public String getId() {
        return this.id;
    }

    public KeyProperties getKeyProperties() {
        return this.keyProperties;
    }

    public CertificatePolicy setKeyProperties(KeyProperties keyProperties) {
        this.keyProperties = keyProperties;
        return this;
    }

    public SecretProperties getSecretProperties() {
        return this.secretProperties;
    }

    public CertificatePolicy setSecretProperties(SecretProperties secretProperties) {
        this.secretProperties = secretProperties;
        return this;
    }

    public X509CertificateProperties getX509CertificateProperties() {
        return this.x509CertificateProperties;
    }

    public CertificatePolicy setX509CertificateProperties(X509CertificateProperties x509CertificateProperties) {
        this.x509CertificateProperties = x509CertificateProperties;
        return this;
    }

    public List<LifetimeAction> getLifetimeActions() {
        return this.lifetimeActions;
    }

    public CertificatePolicy setLifetimeActions(List<LifetimeAction> lifetimeActions) {
        this.lifetimeActions = lifetimeActions;
        return this;
    }

    public IssuerParameters getIssuerParameters() {
        return this.issuerParameters;
    }

    public CertificatePolicy setIssuerParameters(IssuerParameters issuerParameters) {
        this.issuerParameters = issuerParameters;
        return this;
    }

    public CertificateAttributes getAttributes() {
        return this.attributes;
    }

    public CertificatePolicy setAttributes(CertificateAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key_props", (JsonSerializable)this.keyProperties);
        jsonWriter.writeJsonField("secret_props", (JsonSerializable)this.secretProperties);
        jsonWriter.writeJsonField("x509_props", (JsonSerializable)this.x509CertificateProperties);
        jsonWriter.writeArrayField("lifetime_actions", this.lifetimeActions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("issuer", (JsonSerializable)this.issuerParameters);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        return jsonWriter.writeEndObject();
    }

    public static CertificatePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (CertificatePolicy)jsonReader.readObject(reader -> {
            CertificatePolicy deserializedCertificatePolicy = new CertificatePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificatePolicy.id = reader.getString();
                    continue;
                }
                if ("key_props".equals(fieldName)) {
                    deserializedCertificatePolicy.keyProperties = KeyProperties.fromJson(reader);
                    continue;
                }
                if ("secret_props".equals(fieldName)) {
                    deserializedCertificatePolicy.secretProperties = SecretProperties.fromJson(reader);
                    continue;
                }
                if ("x509_props".equals(fieldName)) {
                    deserializedCertificatePolicy.x509CertificateProperties = X509CertificateProperties.fromJson(reader);
                    continue;
                }
                if ("lifetime_actions".equals(fieldName)) {
                    List lifetimeActions;
                    deserializedCertificatePolicy.lifetimeActions = lifetimeActions = reader.readArray(reader1 -> LifetimeAction.fromJson(reader1));
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedCertificatePolicy.issuerParameters = IssuerParameters.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedCertificatePolicy.attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificatePolicy;
        });
    }
}

