/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Trigger
implements JsonSerializable<Trigger> {
    private Integer lifetimePercentage;
    private Integer daysBeforeExpiry;

    public Integer getLifetimePercentage() {
        return this.lifetimePercentage;
    }

    public Trigger setLifetimePercentage(Integer lifetimePercentage) {
        this.lifetimePercentage = lifetimePercentage;
        return this;
    }

    public Integer getDaysBeforeExpiry() {
        return this.daysBeforeExpiry;
    }

    public Trigger setDaysBeforeExpiry(Integer daysBeforeExpiry) {
        this.daysBeforeExpiry = daysBeforeExpiry;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("lifetime_percentage", (Number)this.lifetimePercentage);
        jsonWriter.writeNumberField("days_before_expiry", (Number)this.daysBeforeExpiry);
        return jsonWriter.writeEndObject();
    }

    public static Trigger fromJson(JsonReader jsonReader) throws IOException {
        return (Trigger)jsonReader.readObject(reader -> {
            Trigger deserializedTrigger = new Trigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lifetime_percentage".equals(fieldName)) {
                    deserializedTrigger.lifetimePercentage = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("days_before_expiry".equals(fieldName)) {
                    deserializedTrigger.daysBeforeExpiry = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrigger;
        });
    }
}

