/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.CertificatesUtils;
import com.azure.security.keyvault.certificates.implementation.IssuerPropertiesHelper;
import com.azure.security.keyvault.certificates.implementation.models.CertificateIssuerItem;
import java.io.IOException;

public class IssuerProperties
implements JsonSerializable<IssuerProperties> {
    private static final ClientLogger LOGGER = new ClientLogger(IssuerProperties.class);
    private final CertificateIssuerItem impl;
    private final String name;

    public IssuerProperties() {
        this(new CertificateIssuerItem());
    }

    private IssuerProperties(CertificateIssuerItem impl) {
        this.impl = impl;
        this.name = CertificatesUtils.getIdMetadata(impl.getId(), -1, 3, -1, LOGGER).getName();
    }

    public String getId() {
        return this.impl.getId();
    }

    public String getProvider() {
        return this.impl.getProvider();
    }

    public String getName() {
        return this.name;
    }

    public IssuerProperties setProvider(String provider) {
        this.impl.setProvider(provider);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.impl.toJson(jsonWriter);
    }

    public static IssuerProperties fromJson(JsonReader jsonReader) throws IOException {
        return new IssuerProperties(CertificateIssuerItem.fromJson(jsonReader));
    }

    static {
        IssuerPropertiesHelper.setAccessor(IssuerProperties::new);
    }
}

