/*
 * Decompiled with CFR 0.152.
 */
package com.azure.servicebus.jms;

import com.azure.servicebus.jms.ConnectionStringBuilder;
import com.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import com.azure.servicebus.jms.ServiceBusJmsQueueConnection;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;

public class ServiceBusJmsQueueConnectionFactory
extends ServiceBusJmsConnectionFactory
implements QueueConnectionFactory {
    public ServiceBusJmsQueueConnectionFactory(String connectionString, ServiceBusJmsConnectionFactorySettings settings) {
        super(connectionString, settings);
    }

    public ServiceBusJmsQueueConnectionFactory(ConnectionStringBuilder connectionStringBuilder, ServiceBusJmsConnectionFactorySettings settings) {
        super(connectionStringBuilder, settings);
    }

    public ServiceBusJmsQueueConnectionFactory(String sasKeyName, String sasKey, String host, ServiceBusJmsConnectionFactorySettings settings) {
        super(sasKeyName, sasKey, host, settings);
    }

    @Override
    public QueueConnection createQueueConnection() throws JMSException {
        QueueConnection innerQueueConnection = super.createQueueConnection();
        return new ServiceBusJmsQueueConnection(innerQueueConnection);
    }

    @Override
    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        QueueConnection innerQueueConnection = super.createQueueConnection(userName, password);
        return new ServiceBusJmsQueueConnection(innerQueueConnection);
    }
}

