/*
 * Decompiled with CFR 0.152.
 */
package com.azure.servicebus.jms;

import com.azure.servicebus.jms.jndi.JNDIStorable;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Topic;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.jms.JmsTopic;

public final class ServiceBusJmsTopic
extends JNDIStorable
implements Topic {
    static final String NAME_PROPERTY = "physicalName";
    private Topic innerTopic;

    public ServiceBusJmsTopic() {
    }

    ServiceBusJmsTopic(Topic innerTopic) {
        this.innerTopic = innerTopic;
    }

    public String getTopicName() throws JMSException {
        return this.innerTopic.getTopicName();
    }

    @Override
    protected Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            String name = this.getTopicName();
            properties.put(NAME_PROPERTY, name);
        }
        catch (JMSException exception) {
            String errorMsg = "Cannot get topic name due to exception: " + exception.getMessage();
            throw new JMSRuntimeException(errorMsg, "", (Throwable)exception);
        }
        return Collections.unmodifiableMap(properties);
    }

    @Override
    protected void setProperties(Map<String, String> properties) {
        String name = null;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(NAME_PROPERTY)) continue;
            name = entry.getValue();
        }
        this.checkRequiredProperty(NAME_PROPERTY, name);
        JmsTopic innerTopic = new JmsTopic(name);
        this.innerTopic = innerTopic;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceBusJmsTopic that = (ServiceBusJmsTopic)obj;
        try {
            String thisTopicName = this.getTopicName();
            String thatTopicName = that.getTopicName();
            return thisTopicName != null ? thisTopicName.equals(thatTopicName) : thatTopicName == null;
        }
        catch (JMSException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            String topicName = this.getTopicName();
            return topicName != null ? topicName.hashCode() : 0;
        }
        catch (JMSException e) {
            return 0;
        }
    }

    public String toString() {
        try {
            return "ServiceBusJmsTopic{topicName='" + this.getTopicName() + "'}";
        }
        catch (JMSException e) {
            return "ServiceBusJmsTopic{topicName=<error: " + e.getMessage() + ">}";
        }
    }
}

