/*
 * Decompiled with CFR 0.152.
 */
package com.azure.servicebus.jms;

import com.azure.servicebus.jms.ServiceBusJmsConnection;
import com.azure.servicebus.jms.ServiceBusJmsTopicSession;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;

class ServiceBusJmsTopicConnection
extends ServiceBusJmsConnection
implements TopicConnection {
    private final TopicConnection innerTopicConnection;

    ServiceBusJmsTopicConnection(TopicConnection innerTopicConnection) {
        super((Connection)innerTopicConnection);
        this.innerTopicConnection = innerTopicConnection;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        TopicSession innerTopicSession = this.innerTopicConnection.createTopicSession(transacted, acknowledgeMode);
        return new ServiceBusJmsTopicSession(innerTopicSession);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.innerTopicConnection.createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages);
    }
}

