/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.storage.queue.models.QueueRetentionPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueMetrics
implements XmlSerializable<QueueMetrics> {
    private String version;
    private boolean enabled;
    private Boolean includeApis;
    private QueueRetentionPolicy retentionPolicy;

    public String getVersion() {
        return this.version;
    }

    public QueueMetrics setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public QueueMetrics setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean isIncludeApis() {
        return this.includeApis;
    }

    public QueueMetrics setIncludeApis(Boolean includeApis) {
        this.includeApis = includeApis;
        return this;
    }

    public QueueRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public QueueMetrics setRetentionPolicy(QueueRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "QueueMetrics" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeBooleanElement("IncludeAPIs", this.includeApis);
        xmlWriter.writeXml((XmlSerializable)this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    public static QueueMetrics fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueMetrics.fromXml(xmlReader, null);
    }

    public static QueueMetrics fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "QueueMetrics" : rootElementName;
        return (QueueMetrics)xmlReader.readObject(finalRootElementName, reader -> {
            QueueMetrics deserializedQueueMetrics = new QueueMetrics();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedQueueMetrics.version = reader.getStringElement();
                    continue;
                }
                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedQueueMetrics.enabled = reader.getBooleanElement();
                    continue;
                }
                if ("IncludeAPIs".equals(elementName.getLocalPart())) {
                    deserializedQueueMetrics.includeApis = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedQueueMetrics.retentionPolicy = QueueRetentionPolicy.fromXml(reader, "RetentionPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueMetrics;
        });
    }
}

