/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;

public final class Editor {
    private final Map<String, String> contents;
    private final Map<String, List<String>> lines;

    public Editor(Map<String, String> contents) {
        this.contents = new HashMap<String, String>(contents);
        this.lines = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> content : contents.entrySet()) {
            this.addFile(content.getKey(), content.getValue());
        }
    }

    public boolean packageExists(String packageName) {
        String toFind = "src/main/java/" + packageName.replace('.', '/') + "/";
        return this.contents.keySet().stream().anyMatch(fileName -> fileName.startsWith(toFind));
    }

    public boolean classExists(String packageName, String className) {
        String fileName = "src/main/java/" + packageName.replace('.', '/') + "/" + className + ".java";
        return this.contents.containsKey(fileName);
    }

    public List<String> classesInPackage(String packageName) {
        String packagePath = "src/main/java/" + packageName.replace(".", "/") + "/";
        return this.contents.keySet().stream().filter(fileName -> fileName.startsWith(packagePath)).map(fileName -> fileName.substring(packagePath.length(), fileName.length() - 5)).filter(className -> !className.contains("/")).collect(Collectors.toList());
    }

    public Map<String, String> getContents() {
        return this.contents;
    }

    public void addFile(String name, String content) {
        this.addOrReplaceFile(name, content, false);
    }

    public void replaceFile(String name, String content) {
        this.addOrReplaceFile(name, content, true);
    }

    private void addOrReplaceFile(String name, String content, boolean isReplace) {
        if (isReplace || !this.contents.containsKey(name)) {
            this.contents.put(name, content);
            this.lines.put(name, Editor.splitContentIntoLines(content));
        }
    }

    public void removeFile(String name) {
        this.contents.remove(name);
        this.lines.remove(name);
    }

    public String getFileContent(String name) {
        return this.contents.get(name);
    }

    public List<String> getFileLines(String name) {
        return this.lines.get(name);
    }

    public String getFileLine(String name, int line) {
        return this.lines.get(name).get(line);
    }

    private static List<String> splitContentIntoLines(String content) {
        ArrayList<String> res = new ArrayList<String>();
        Scanner scanner = new Scanner(content);
        while (scanner.hasNextLine()) {
            res.add(scanner.nextLine());
        }
        if (content.endsWith("\n")) {
            res.add("");
        }
        return res;
    }
}

