/*
 * Decompiled with CFR 0.152.
 */
package com.azure.autorest.customization;

import com.azure.autorest.customization.ClassCustomization;
import com.azure.autorest.customization.Editor;
import java.util.List;
import java.util.stream.Collectors;

public final class PackageCustomization {
    private final Editor editor;
    private final String packageName;

    PackageCustomization(Editor editor, String packageName) {
        this.editor = editor;
        this.packageName = packageName;
    }

    public ClassCustomization getClass(String className) {
        if (!this.editor.classExists(this.packageName, className)) {
            throw new IllegalArgumentException(className + " does not exist in package " + this.packageName);
        }
        return new ClassCustomization(this.editor, this.packageName, className);
    }

    public List<ClassCustomization> listClasses() {
        return this.editor.classesInPackage(this.packageName).stream().map(className -> new ClassCustomization(this.editor, this.packageName, (String)className)).collect(Collectors.toList());
    }
}

