/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.junit.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.extension.ExtensionContext;

class AgentConfigurator {
    private static final AtomicBoolean hasBeenConfigured = new AtomicBoolean();

    AgentConfigurator() {
    }

    static void forRegressionTest(ExtensionContext extensionContext) {
        if (!hasBeenConfigured.compareAndSet(false, true)) {
            return;
        }
        AgentConfigurator.applyCommonConfiguration(extensionContext);
        Opt.conditionalHooks.setIfDefault((Object)true);
        Opt.instrument.setIfDefault(AgentConfigurator.determineInstrumentationFilters(extensionContext));
        Opt.instrumentationExcludes.setIfDefault(Collections.singletonList("**"));
        Opt.customHookIncludes.setIfDefault((Object)((List)Opt.instrument.get()));
    }

    static void forFuzzing(ExtensionContext extensionContext, String fuzzingDuration, long maxExecutions) {
        if (!hasBeenConfigured.compareAndSet(false, true)) {
            throw new IllegalStateException("Only a single fuzz test should be executed per fuzzing run");
        }
        AgentConfigurator.applyCommonConfiguration(extensionContext);
        Opt.maxDuration.setIfDefault((Object)fuzzingDuration);
        Opt.maxExecutions.setIfDefault((Object)maxExecutions);
        Opt.instrument.setIfDefault(AgentConfigurator.determineInstrumentationFilters(extensionContext));
        Opt.customHookIncludes.setIfDefault((Object)((List)Opt.instrument.get()));
        Opt.instrumentationIncludes.setIfDefault((Object)((List)Opt.instrument.get()));
    }

    private static List<String> determineInstrumentationFilters(ExtensionContext extensionContext) {
        return Utils.getClassPathBasedInstrumentationFilter(System.getProperty("java.class.path")).orElseGet(() -> Utils.getLegacyInstrumentationFilter(extensionContext.getRequiredTestClass()));
    }

    private static void applyCommonConfiguration(ExtensionContext extensionContext) {
        Opt.registerConfigurationParameters(arg_0 -> ((ExtensionContext)extensionContext).getConfigurationParameter(arg_0));
        Opt.customHookExcludes.setIfDefault(Arrays.asList("com.google.testing.junit.**", "com.intellij.**", "org.jetbrains.**", "io.github.classgraph.**", "junit.framework.**", "net.bytebuddy.**", "org.apiguardian.**", "org.assertj.core.**", "org.hamcrest.**", "org.junit.**", "org.opentest4j.**", "org.mockito.**", "org.apache.maven.**", "org.gradle.**"));
        if (Utils.isGatheringCoverage()) {
            Opt.additionalClassesExcludes.setIfDefault(Arrays.asList("java.util.regex.**"));
        }
    }
}

