/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.agent.AgentInstaller;
import com.code_intelligence.jazzer.driver.FuzzTargetHolder;
import com.code_intelligence.jazzer.driver.FuzzTargetRunner;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.junit.AgentConfigurator;
import com.code_intelligence.jazzer.junit.ApiStatsHolder;
import com.code_intelligence.jazzer.junit.ApiStatsInterval;
import com.code_intelligence.jazzer.junit.ExitCodeException;
import com.code_intelligence.jazzer.junit.FuzzTestConfigurationError;
import com.code_intelligence.jazzer.junit.FuzzTestFindingException;
import com.code_intelligence.jazzer.junit.JUnitLifecycleMethodsInvoker;
import com.code_intelligence.jazzer.junit.Lifecycle;
import com.code_intelligence.jazzer.junit.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.platform.commons.support.AnnotationSupport;

class FuzzTestExecutor {
    private static final AtomicBoolean hasBeenPrepared = new AtomicBoolean();
    private static final AtomicBoolean agentInstalled = new AtomicBoolean(false);
    private final List<String> libFuzzerArgs;
    private final Optional<Path> javaSeedsDir;

    private FuzzTestExecutor(List<String> libFuzzerArgs, Optional<Path> javaSeedsDir) {
        this.libFuzzerArgs = libFuzzerArgs;
        this.javaSeedsDir = javaSeedsDir;
    }

    public static FuzzTestExecutor prepare(ExtensionContext context, Optional<Path> dictionaryPath) throws IOException {
        Optional<Path> javaSeedsDir;
        if (!hasBeenPrepared.compareAndSet(false, true)) {
            throw new FuzzTestConfigurationError("FuzzTestExecutor#prepare can only be called once per test run");
        }
        List allSources = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)context.getRequiredTestMethod(), ArgumentsSource.class);
        ArgumentsSource lastSource = (ArgumentsSource)allSources.get(allSources.size() - 1);
        if (lastSource.value().getPackage() != FuzzTestExecutor.class.getPackage()) {
            throw new FuzzTestConfigurationError("@FuzzTest must be the last annotation on a fuzz test, but it came after the (meta-)annotation " + lastSource);
        }
        List<String> originalLibFuzzerArgs = Utils.getLibFuzzerArgs(context);
        String argv0 = originalLibFuzzerArgs.isEmpty() ? "fake_argv0" : originalLibFuzzerArgs.remove(0);
        ArrayList<String> libFuzzerArgs = new ArrayList<String>();
        libFuzzerArgs.add(argv0);
        List<String> corpusFilesOrDirs = Utils.getCorpusFilesOrDirs(context);
        originalLibFuzzerArgs.removeAll(corpusFilesOrDirs);
        libFuzzerArgs.addAll(corpusFilesOrDirs);
        if (!corpusFilesOrDirs.isEmpty() && corpusFilesOrDirs.stream().map(x$0 -> Paths.get(x$0, new String[0])).allMatch(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))) {
            javaSeedsDir = Optional.empty();
        } else {
            boolean createDefaultGeneratedCorpusDir = corpusFilesOrDirs.isEmpty();
            javaSeedsDir = Optional.of(FuzzTestExecutor.addInputAndSeedDirs(context, libFuzzerArgs, createDefaultGeneratedCorpusDir));
        }
        dictionaryPath.ifPresent(s -> libFuzzerArgs.add("-dict=" + s));
        libFuzzerArgs.add("-max_total_time=" + com.code_intelligence.jazzer.utils.Utils.durationStringToSeconds((String)((String)Opt.maxDuration.get())));
        if ((Long)Opt.maxExecutions.get() > 0L) {
            libFuzzerArgs.add("-runs=" + Opt.maxExecutions.get());
        }
        libFuzzerArgs.add("-rss_limit_mb=0");
        if (Utils.permissivelyParseBoolean(context.getConfigurationParameter("jazzer.valueprofile").orElse("false"))) {
            libFuzzerArgs.add("-use_value_profile=1");
        }
        FuzzTestExecutor.translateJUnitTimeoutToLibFuzzerFlag(context).ifPresent(libFuzzerArgs::add);
        libFuzzerArgs.addAll(originalLibFuzzerArgs);
        return new FuzzTestExecutor(libFuzzerArgs, javaSeedsDir);
    }

    private static Optional<String> translateJUnitTimeoutToLibFuzzerFlag(ExtensionContext context) {
        return Stream.of(() -> AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), Timeout.class).map(timeout -> timeout.unit().toSeconds(timeout.value())), () -> AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), Timeout.class).map(timeout -> timeout.unit().toSeconds(timeout.value())), () -> context.getConfigurationParameter("junit.jupiter.execution.timeout.testtemplate.method.default", Utils::parseJUnitTimeoutValueToSeconds), () -> context.getConfigurationParameter("junit.jupiter.execution.timeout.testable.method.default", Utils::parseJUnitTimeoutValueToSeconds), () -> context.getConfigurationParameter("junit.jupiter.execution.timeout.default", Utils::parseJUnitTimeoutValueToSeconds)).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().map(timeoutSeconds -> String.format("-timeout=%d", timeoutSeconds));
    }

    private static Path addInputAndSeedDirs(ExtensionContext context, List<String> libFuzzerArgs, boolean createDefaultGeneratedCorpusDir) throws IOException {
        Optional<Path> inputsDirectory;
        URL inputsDirectoryUrl;
        Optional<Path> findingsDirectory;
        Class fuzzTestClass = context.getRequiredTestClass();
        Method fuzzTestMethod = context.getRequiredTestMethod();
        Path baseDir = Paths.get(context.getConfigurationParameter("jazzer.internal.basedir").orElse(""), new String[0]).toAbsolutePath();
        Path generatedCorpusDir = baseDir.resolve(Utils.generatedCorpusPath(fuzzTestClass, fuzzTestMethod));
        if (createDefaultGeneratedCorpusDir) {
            Files.createDirectories(generatedCorpusDir, new FileAttribute[0]);
        }
        if (Files.exists(generatedCorpusDir, new LinkOption[0])) {
            String absoluteCorpusDir = generatedCorpusDir.toAbsolutePath().toString();
            if (Utils.isWindows()) {
                absoluteCorpusDir = "\\\\?\\" + absoluteCorpusDir;
            }
            libFuzzerArgs.add(absoluteCorpusDir);
        }
        if (!(findingsDirectory = Utils.inputsDirectorySourcePath(fuzzTestClass, fuzzTestMethod, baseDir)).isPresent()) {
            context.publishReportEntry(String.format("Collecting crashing inputs in the project root directory.\nIf you want to keep them organized by fuzz test and automatically run them as regression tests with JUnit Jupiter, create a test resource directory called '%s' in package '%s' and move the files there.", Utils.inputsDirectoryResourcePath(fuzzTestClass, fuzzTestMethod), fuzzTestClass.getPackage().getName()));
        }
        if ((inputsDirectoryUrl = fuzzTestClass.getResource(Utils.inputsDirectoryResourcePath(fuzzTestClass, fuzzTestMethod))) != null && "file".equals(inputsDirectoryUrl.getProtocol())) {
            try {
                inputsDirectory = Optional.of(Paths.get(inputsDirectoryUrl.toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (inputsDirectoryUrl != null && !findingsDirectory.isPresent()) {
                context.publishReportEntry("When running Jazzer fuzz tests from a JAR rather than class files, the inputs directory isn't used unless it is located under src/test/resources/...");
            }
            inputsDirectory = findingsDirectory;
        }
        inputsDirectory.ifPresent(dir -> libFuzzerArgs.add(dir.toAbsolutePath().toString()));
        Path javaSeedsDir = Files.createTempDirectory("jazzer-java-seeds", new FileAttribute[0]);
        libFuzzerArgs.add(javaSeedsDir.toAbsolutePath().toString());
        libFuzzerArgs.add(String.format("-artifact_prefix=%s%c", findingsDirectory.orElse(baseDir).toAbsolutePath(), Character.valueOf(File.separatorChar)));
        return javaSeedsDir;
    }

    static void configureAndInstallAgent(ExtensionContext extensionContext, String maxDuration, long maxExecutions, Optional<Path> dictionaryPath) throws IOException {
        if (!agentInstalled.compareAndSet(false, true)) {
            return;
        }
        if (Utils.isFuzzing(extensionContext)) {
            AgentConfigurator.forFuzzing(extensionContext, maxDuration, maxExecutions);
            FuzzTestExecutor executor = FuzzTestExecutor.prepare(extensionContext, dictionaryPath);
            extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put(FuzzTestExecutor.class, (Object)executor);
        } else {
            AgentConfigurator.forRegressionTest(extensionContext);
        }
        AgentInstaller.install((boolean)((Boolean)Opt.hooks.get()));
    }

    static FuzzTestExecutor fromContext(ExtensionContext extensionContext) {
        return (FuzzTestExecutor)extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).get(FuzzTestExecutor.class, FuzzTestExecutor.class);
    }

    public void addSeed(byte[] bytes) throws IOException {
        byte[] hash;
        if (!this.javaSeedsDir.isPresent()) {
            return;
        }
        Path tmpSeed = Files.createTempFile(this.javaSeedsDir.get(), "tmp-seed-", null, new FileAttribute[0]);
        Files.write(tmpSeed, bytes, new OpenOption[0]);
        try {
            hash = MessageDigest.getInstance("SHA-256").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        String basename = "seed-" + Base64.getUrlEncoder().withoutPadding().encodeToString(hash);
        Path seed = this.javaSeedsDir.get().resolve(basename);
        Files.move(tmpSeed, seed, StandardCopyOption.REPLACE_EXISTING);
    }

    public Optional<Throwable> execute(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, Lifecycle lifecycle) {
        FuzzTargetHolder.fuzzTarget = new FuzzTargetHolder.FuzzTarget((Method)invocationContext.getExecutable(), JUnitLifecycleMethodsInvoker.of(extensionContext, lifecycle));
        AtomicReference atomicFinding = new AtomicReference();
        try {
            FuzzTargetRunner.registerFatalFindingHandlerForJUnit(atomicFinding::set);
        }
        catch (Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (throwable instanceof ExceptionInInitializerError && cause instanceof RuntimeException) {
                throw new FuzzTestConfigurationError("Error initializing FuzzTargetRunner ", cause);
            }
            throw throwable;
        }
        ApiStatsHolder.apiStats = new ApiStatsInterval();
        int exitCode = FuzzTargetRunner.startLibFuzzer(this.libFuzzerArgs);
        this.javaSeedsDir.ifPresent(FuzzTestExecutor::deleteJavaSeedsDir);
        Throwable finding = (Throwable)atomicFinding.get();
        ApiStatsHolder.printApiStats();
        if (finding != null) {
            return Optional.of(new FuzzTestFindingException(finding));
        }
        if (exitCode != 0) {
            return Optional.of(new ExitCodeException("Jazzer exited with exit code " + exitCode, exitCode));
        }
        return Optional.empty();
    }

    private static void deleteJavaSeedsDir(Path javaSeedsDir) {
        try (Stream<Path> entries = Files.list(javaSeedsDir);){
            entries.forEach(FuzzTestExecutor::deleteIgnoringErrors);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FuzzTestExecutor.deleteIgnoringErrors(javaSeedsDir);
    }

    private static void deleteIgnoringErrors(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

