/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.driver.FuzzedDataProviderImpl;
import com.code_intelligence.jazzer.junit.FuzzTestConfigurationError;
import com.code_intelligence.jazzer.mutation.ArgumentsMutator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;

interface SeedSerializer {
    public Object[] read(byte[] var1);

    public byte[] write(Object[] var1) throws UnsupportedOperationException;

    public static SeedSerializer of(Method method) {
        if (method.getParameterCount() == 0) {
            throw new FuzzTestConfigurationError("Methods annotated with @FuzzTest must take at least one parameter");
        }
        if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == byte[].class) {
            return new ByteArraySeedSerializer();
        }
        if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FuzzedDataProvider.class) {
            return new FuzzedDataProviderSeedSerializer();
        }
        try {
            return new ArgumentsMutatorSeedSerializer(ArgumentsMutator.forMethodOrThrow((Method)method));
        }
        catch (IllegalArgumentException e) {
            throw new FuzzTestConfigurationError(e.getMessage());
        }
    }

    public static final class ByteArraySeedSerializer
    implements SeedSerializer {
        @Override
        public Object[] read(byte[] bytes) {
            return new Object[]{bytes};
        }

        @Override
        public byte[] write(Object[] args) {
            return (byte[])args[0];
        }
    }

    public static final class FuzzedDataProviderSeedSerializer
    implements SeedSerializer {
        @Override
        public Object[] read(byte[] bytes) {
            return new Object[]{FuzzedDataProviderImpl.withJavaData((byte[])bytes)};
        }

        @Override
        public byte[] write(Object[] args) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ArgumentsMutatorSeedSerializer
    implements SeedSerializer {
        private final ArgumentsMutator mutator;

        public ArgumentsMutatorSeedSerializer(ArgumentsMutator mutator) {
            this.mutator = mutator;
        }

        @Override
        public Object[] read(byte[] bytes) {
            this.mutator.read(new ByteArrayInputStream(bytes));
            return this.mutator.getArguments();
        }

        @Override
        public byte[] write(Object[] args) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.mutator.writeAny((OutputStream)out, args);
            return out.toByteArray();
        }
    }
}

