/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.junit.ApiStatsHolder;
import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

public final class SpringFuzzTestHelper {
    private static final int API_ERROR_STATUS_CODE = 500;

    public static ResultMatcher statusIsNot5xxServerError() {
        return result -> AssertionErrors.assertNotEquals((String)("Range for response status value " + result.getResponse().getStatus()), (Object)HttpStatus.Series.SERVER_ERROR, (Object)HttpStatus.Series.resolve((int)result.getResponse().getStatus()));
    }

    public static ResultActions apiTest(MockMvc mockMvc, String requestURI, MockHttpServletRequestBuilder requestBuilder) throws Exception {
        String method = requestBuilder.buildRequest(mockMvc.getDispatcherServlet().getServletContext()).getMethod();
        try {
            return mockMvc.perform((RequestBuilder)requestBuilder).andDo(SpringFuzzTestHelper.collectApiStats(requestURI));
        }
        catch (Exception e) {
            ApiStatsHolder.collectApiStats(requestURI, method, 500);
            throw e;
        }
    }

    public static ResultHandler collectApiStats(String requestURI) {
        return result -> ApiStatsHolder.collectApiStats(requestURI, result.getRequest().getMethod(), result.getResponse().getStatus());
    }
}

