/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.utils.UnsafeProvider;
import com.code_intelligence.jazzer.utils.UnsafeUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.params.provider.Arguments;

class Utils {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(?iu)([0-9]*) ?(ns|\u03bcs|ms|s|m|h|d)?");
    private static final Map<String, TimeUnit> DURATION_UNITS_LOOKUP;
    private static final Pattern CLASSPATH_SPLITTER;
    private static final Pattern COVERAGE_AGENT_ARG;
    private static final boolean SET_FUZZING_ENV;
    private static final boolean IS_FUZZING_ENV;
    private static final ClassValue<Object> uniqueInstanceCache;
    private static final Set<Object> uniqueInstances;

    Utils() {
    }

    static String inputsDirectoryResourcePath(Class<?> testClass, Method testMethod) {
        return testClass.getSimpleName() + "Inputs/" + testMethod.getName();
    }

    static String inputsDirectoryResourcePath(Class<?> testClass) {
        return testClass.getSimpleName() + "Inputs";
    }

    static Optional<Path> inputsDirectorySourcePath(Class<?> testClass, Method testMethod, Path baseDir) {
        Path testResourcesDirectory;
        String inputsResourcePath = Utils.inputsDirectoryResourcePath(testClass, testMethod);
        if (!inputsResourcePath.startsWith("/")) {
            String inputsPackage = testClass.getPackage().getName().replace('.', '/');
            inputsResourcePath = "/" + inputsPackage + "/" + inputsResourcePath;
        }
        Path sourceInputsDirectory = testResourcesDirectory = baseDir.resolve("src").resolve("test").resolve("resources");
        for (String segment : inputsResourcePath.split("/")) {
            sourceInputsDirectory = sourceInputsDirectory.resolve(segment);
        }
        if (Files.isDirectory(sourceInputsDirectory, new LinkOption[0])) {
            return Optional.of(sourceInputsDirectory);
        }
        if (!Files.isDirectory(testResourcesDirectory, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return Optional.of(Files.createDirectories(sourceInputsDirectory, new FileAttribute[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    static Path generatedCorpusPath(Class<?> testClass, Method testMethod) {
        return Paths.get(".cifuzz-corpus", testClass.getName(), testMethod.getName());
    }

    static List<String> getLegacyInstrumentationFilter(Class<?> testClass) {
        String packageName = testClass.getPackage().getName();
        String[] packageSegments = packageName.split("\\.");
        int numSegments = 2;
        if (packageSegments.length > 2 && packageSegments[0].equals("com") && packageSegments[1].equals("github")) {
            numSegments = 3;
        }
        return Collections.singletonList(Stream.concat(Arrays.stream(packageSegments).limit(numSegments), Stream.of("**")).collect(Collectors.joining(".")));
    }

    static Optional<List<String>> getClassPathBasedInstrumentationFilter(String classPath) {
        List includes = CLASSPATH_SPLITTER.splitAsStream(classPath).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(root -> {
            final HashSet pkgs = new HashSet();
            try {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes basicFileAttributes) throws IOException {
                        try (Stream<Path> entries = Files.list(dir);){
                            if (entries.filter(path -> path.toString().endsWith(".class")).anyMatch(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))) {
                                Path pkgPath = root.relativize(dir);
                                pkgs.add(pkgPath);
                                if (pkgPath.toString().isEmpty()) {
                                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                                    return fileVisitResult;
                                }
                                FileVisitResult fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                                return fileVisitResult;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                return Stream.of(new Path[0]);
            }
            return pkgs.stream();
        }).distinct().collect(Collectors.toList());
        if (includes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(includes.stream().map(Path::toString).map(path -> path.isEmpty() ? "*" : path.replace(File.separator, ".") + ".**").sorted().collect(Collectors.toList()));
    }

    private static boolean isCoverageAgentPresent() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(s -> COVERAGE_AGENT_ARG.matcher((CharSequence)s).matches());
    }

    static boolean isGatheringCoverage() {
        return Utils.isCoverageAgentPresent() || Utils.permissivelyParseBoolean(System.getenv("JAZZER_COVERAGE"));
    }

    static boolean permissivelyParseBoolean(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes"));
    }

    static boolean isFuzzing(ExtensionContext extensionContext) {
        return SET_FUZZING_ENV ? IS_FUZZING_ENV : Utils.runFromCommandLine(extensionContext);
    }

    static boolean runFromCommandLine(ExtensionContext extensionContext) {
        return extensionContext.getConfigurationParameter("jazzer.internal.command_line").map(Boolean::parseBoolean).orElse(false);
    }

    static List<String> getLibFuzzerArgs(ExtensionContext extensionContext) {
        Optional arg;
        ArrayList<String> args = new ArrayList<String>();
        int i = 0;
        while ((arg = extensionContext.getConfigurationParameter("jazzer.internal.arg." + i)).isPresent()) {
            args.add((String)arg.get());
            ++i;
        }
        return args;
    }

    static List<String> getCorpusFilesOrDirs(ExtensionContext context) {
        return Utils.getLibFuzzerArgs(context).stream().skip(1L).filter(arg -> !arg.startsWith("-")).collect(Collectors.toList());
    }

    static long parseJUnitTimeoutValueToSeconds(String value) {
        Matcher matcher = DURATION_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Failed to parse timeout duration string: " + value);
        }
        long count = Long.parseUnsignedLong(matcher.group(1));
        TimeUnit unit = DURATION_UNITS_LOOKUP.getOrDefault(matcher.group(2), TimeUnit.SECONDS);
        long seconds = unit.toSeconds(count);
        return seconds != 0L ? seconds : 1L;
    }

    static Arguments getMarkedArguments(Method method, String displayName) {
        return Arguments.arguments((Object[])Arrays.stream(method.getParameterTypes()).map(Utils::getMarkedInstance).map(arg -> Named.named((String)displayName, (Object)arg)).toArray(Object[]::new));
    }

    static boolean isMarkedInvocation(ReflectiveInvocationContext<Method> invocationContext) {
        if (invocationContext.getArguments().stream().anyMatch(Utils::isMarkedInstance)) {
            if (invocationContext.getArguments().stream().allMatch(Utils::isMarkedInstance)) {
                return true;
            }
            throw new IllegalStateException("Some, but not all arguments were marked in invocation of " + invocationContext);
        }
        return false;
    }

    static <T> T getMarkedInstance(Class<T> clazz) {
        Object instance = uniqueInstanceCache.get(clazz);
        uniqueInstances.add(instance);
        return (T)instance;
    }

    static boolean isMarkedInstance(Object instance) {
        return uniqueInstances.contains(instance);
    }

    private static Object makeMarkedInstance(Class<?> clazz) {
        if (clazz == Class.class) {
            return new Object(){}.getClass();
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 0);
        }
        if (clazz.isInterface()) {
            return Proxy.newProxyInstance(Utils.class.getClassLoader(), new Class[]{clazz}, (o, method, objects) -> null);
        }
        if (clazz.isPrimitive()) {
            clazz = MethodType.methodType(clazz).wrap().returnType();
        } else if (Modifier.isAbstract(clazz.getModifiers())) {
            clazz = UnsafeUtils.defineAnonymousConcreteSubclass(clazz);
        }
        try {
            return clazz.cast(UnsafeProvider.getUnsafe().allocateInstance(clazz));
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    static {
        HashMap<String, TimeUnit> units = new HashMap<String, TimeUnit>();
        units.put("ns", TimeUnit.NANOSECONDS);
        units.put("\u03bcs", TimeUnit.MICROSECONDS);
        units.put("ms", TimeUnit.MILLISECONDS);
        units.put("s", TimeUnit.SECONDS);
        units.put("m", TimeUnit.MINUTES);
        units.put("h", TimeUnit.HOURS);
        units.put("d", TimeUnit.DAYS);
        DURATION_UNITS_LOOKUP = Collections.unmodifiableMap(units);
        CLASSPATH_SPLITTER = Pattern.compile(Pattern.quote(File.pathSeparator));
        COVERAGE_AGENT_ARG = Pattern.compile("-javaagent:.*(?:intellij-coverage-agent|intellij\\.platform\\.coverage\\.agent|jacoco).*");
        SET_FUZZING_ENV = System.getenv("JAZZER_FUZZ") != null || System.getProperty("JAZZER_FUZZ") != null;
        IS_FUZZING_ENV = Utils.permissivelyParseBoolean(System.getenv("JAZZER_FUZZ")) || Utils.permissivelyParseBoolean(System.getProperty("JAZZER_FUZZ"));
        uniqueInstanceCache = new ClassValue<Object>(){

            @Override
            protected Object computeValue(Class<?> clazz) {
                return Utils.makeMarkedInstance(clazz);
            }
        };
        uniqueInstances = Collections.newSetFromMap(new IdentityHashMap());
    }
}

