/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client;

import com.datastax.astra.client.DataAPIOptions;
import com.datastax.astra.client.Database;
import com.datastax.astra.client.exception.DataAPIFaultyResponseException;
import com.datastax.astra.client.exception.DataApiException;
import com.datastax.astra.client.exception.TooManyDocumentsToCountException;
import com.datastax.astra.client.model.BulkWriteOptions;
import com.datastax.astra.client.model.BulkWriteResult;
import com.datastax.astra.client.model.CollectionIdTypes;
import com.datastax.astra.client.model.CollectionInfo;
import com.datastax.astra.client.model.CollectionOptions;
import com.datastax.astra.client.model.Command;
import com.datastax.astra.client.model.CommandOptions;
import com.datastax.astra.client.model.CountDocumentsOptions;
import com.datastax.astra.client.model.DataAPIKeywords;
import com.datastax.astra.client.model.DeleteManyOptions;
import com.datastax.astra.client.model.DeleteOneOptions;
import com.datastax.astra.client.model.DeleteResult;
import com.datastax.astra.client.model.DistinctIterable;
import com.datastax.astra.client.model.Document;
import com.datastax.astra.client.model.EstimatedCountDocumentsOptions;
import com.datastax.astra.client.model.Filter;
import com.datastax.astra.client.model.Filters;
import com.datastax.astra.client.model.FindIterable;
import com.datastax.astra.client.model.FindOneAndDeleteOptions;
import com.datastax.astra.client.model.FindOneAndReplaceOptions;
import com.datastax.astra.client.model.FindOneAndReplaceResult;
import com.datastax.astra.client.model.FindOneAndUpdateOptions;
import com.datastax.astra.client.model.FindOneOptions;
import com.datastax.astra.client.model.FindOptions;
import com.datastax.astra.client.model.InsertManyOptions;
import com.datastax.astra.client.model.InsertManyResult;
import com.datastax.astra.client.model.InsertOneOptions;
import com.datastax.astra.client.model.InsertOneResult;
import com.datastax.astra.client.model.ObjectId;
import com.datastax.astra.client.model.Page;
import com.datastax.astra.client.model.ReplaceOneOptions;
import com.datastax.astra.client.model.ReturnDocument;
import com.datastax.astra.client.model.Sort;
import com.datastax.astra.client.model.UUIDv6;
import com.datastax.astra.client.model.UUIDv7;
import com.datastax.astra.client.model.Update;
import com.datastax.astra.client.model.UpdateManyOptions;
import com.datastax.astra.client.model.UpdateOneOptions;
import com.datastax.astra.client.model.UpdateResult;
import com.datastax.astra.internal.api.ApiResponse;
import com.datastax.astra.internal.command.AbstractCommandRunner;
import com.datastax.astra.internal.command.CommandObserver;
import com.datastax.astra.internal.utils.AnsiUtils;
import com.datastax.astra.internal.utils.Assert;
import com.datastax.astra.internal.utils.JsonUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Collection<T>
extends AbstractCommandRunner {
    private static final Logger log = LoggerFactory.getLogger(Collection.class);
    private static final String ARG_OPTIONS = "options";
    private static final String ARG_FILTER = "filter";
    private static final String ARG_DATABASE = "database";
    private static final String ARG_CLAZZ = "working class 'clazz'";
    private static final String ARG_COLLECTION_NAME = "collectionName";
    private static final String ARG_EMBEDDINGS = "vector embeddings";
    private static final String ARG_VECTORIZE = "expression to vectorize";
    private static final String ARG_UPDATE = "update";
    private static final String ARG_COMMANDS = "commands";
    private static final String DOCUMENT = "document";
    private static final String RESULT_INSERTED_IDS = "insertedIds";
    public static final String RESULT_DELETED_COUNT = "deletedCount";
    public static final String RESULT_MATCHED_COUNT = "matchedCount";
    public static final String RESULT_MODIFIED_COUNT = "modifiedCount";
    public static final String RESULT_UPSERTED_ID = "upsertedId";
    public static final String RESULT_MORE_DATA = "moreData";
    public static final String RESULT_COUNT = "count";
    public static final String INPUT_INCLUDE_SIMILARITY = "includeSimilarity";
    public static final String INPUT_INCLUDE_SORT_VECTOR = "includeSortVector";
    private static final String INPUT_UPSERT = "upsert";
    private static final String INPUT_RETURN_DOCUMENT = "returnDocument";
    private static final String INPUT_ORDERED = "ordered";
    private static final String INPUT_PAGE_STATE = "pageState";
    private final String collectionName;
    protected final Class<T> documentClass;
    private final Database database;
    private final DataAPIOptions dataAPIOptions;
    private final String apiEndpoint;
    private CollectionOptions options;
    private boolean optionChecked = false;

    protected Collection(Database db, String collectionName, CommandOptions<?> commandOptions, Class<T> clazz) {
        Assert.notNull(db, ARG_DATABASE);
        Assert.notNull(clazz, ARG_CLAZZ);
        Assert.hasLength(collectionName, ARG_COLLECTION_NAME);
        this.collectionName = collectionName;
        this.database = db;
        this.dataAPIOptions = db.getOptions();
        this.documentClass = clazz;
        this.commandOptions = commandOptions;
        this.apiEndpoint = db.getApiEndpoint() + "/" + collectionName;
    }

    public String getNamespaceName() {
        return this.getDatabase().getNamespaceName();
    }

    public CollectionInfo getDefinition() {
        return this.database.listCollections().filter(col -> col.getName().equals(this.collectionName)).findFirst().orElseThrow(() -> new DataApiException("[COLLECTION_NOT_EXIST] - Collection does not exist, collection name: '" + this.collectionName + "'", "COLLECTION_NOT_EXIST", null));
    }

    public CollectionOptions getOptions() {
        if (!this.optionChecked) {
            this.options = Optional.ofNullable(this.getDefinition().getOptions()).orElse(new CollectionOptions());
            this.optionChecked = true;
        }
        return this.options;
    }

    public String getName() {
        return this.collectionName;
    }

    public final InsertOneResult insertOne(T document) {
        return this.insertOne(document, (InsertOneOptions)null);
    }

    public final InsertOneResult insertOne(T document, InsertOneOptions insertOneOptions) {
        Assert.notNull(document, DOCUMENT);
        return this.internalInsertOne(JsonUtils.convertValue(document, Document.class), insertOneOptions);
    }

    public final CompletableFuture<InsertOneResult> insertOneAsync(T document) {
        return CompletableFuture.supplyAsync(() -> this.insertOne(document));
    }

    public final CompletableFuture<InsertOneResult> insertOneAsync(T document, InsertOneOptions options) {
        return CompletableFuture.supplyAsync(() -> this.insertOne(document, options));
    }

    public final InsertOneResult insertOne(T document, float[] embeddings) {
        return this.insertOne(document, embeddings, null);
    }

    public final InsertOneResult insertOne(T document, float[] embeddings, InsertOneOptions options) {
        Assert.notNull(document, DOCUMENT);
        Assert.notNull(embeddings, ARG_EMBEDDINGS);
        return this.internalInsertOne(JsonUtils.convertValue(document, Document.class).vector(embeddings), options);
    }

    public final CompletableFuture<InsertOneResult> insertOneAsync(T document, float[] embeddings) {
        return CompletableFuture.supplyAsync(() -> this.insertOne(document, embeddings));
    }

    public final InsertOneResult insertOne(T document, String vectorize, InsertOneOptions options) {
        Assert.notNull(document, DOCUMENT);
        Assert.hasLength(vectorize, ARG_VECTORIZE);
        return this.internalInsertOne(JsonUtils.convertValue(document, Document.class).vectorize(vectorize), options);
    }

    public final InsertOneResult insertOne(T document, String vectorize) {
        Assert.notNull(document, DOCUMENT);
        Assert.hasLength(vectorize, ARG_VECTORIZE);
        return this.insertOne(document, vectorize, null);
    }

    public final CompletableFuture<InsertOneResult> insertOneAsync(T document, String vectorize) {
        return CompletableFuture.supplyAsync(() -> this.insertOne(document, vectorize));
    }

    private InsertOneResult internalInsertOne(Document document, InsertOneOptions insertOneOptions) {
        Assert.notNull(document, DOCUMENT);
        Command insertOne = Command.create("insertOne").withDocument(document);
        Object documentId = this.runCommand(insertOne, insertOneOptions).getStatusKeyAsList(RESULT_INSERTED_IDS, Object.class).get(0);
        return new InsertOneResult(this.unmarshallDocumentId(documentId));
    }

    private Object unmarshallDocumentId(Object id) {
        if (id instanceof Map) {
            Map mapId = (Map)id;
            if (mapId.containsKey(DataAPIKeywords.DATE.getKeyword())) {
                return Instant.ofEpochMilli((Long)mapId.get(DataAPIKeywords.DATE.getKeyword()));
            }
            if (mapId.containsKey(DataAPIKeywords.UUID.getKeyword())) {
                UUID uid = UUID.fromString((String)mapId.get(DataAPIKeywords.UUID.getKeyword()));
                if (this.getOptions() != null && this.getOptions().getDefaultId() != null) {
                    CollectionIdTypes defaultIdType = CollectionIdTypes.fromValue(this.getOptions().getDefaultId().getType());
                    switch (defaultIdType) {
                        case UUIDV6: {
                            return new UUIDv6(uid);
                        }
                        case UUIDV7: {
                            return new UUIDv7(uid);
                        }
                    }
                    return uid;
                }
                throw new IllegalStateException("Returned is is a UUID, but no defaultId is set in the collection definition.");
            }
            if (mapId.containsKey(DataAPIKeywords.OBJECT_ID.getKeyword())) {
                return new ObjectId((String)mapId.get(DataAPIKeywords.OBJECT_ID.getKeyword()));
            }
            throw new IllegalArgumentException("Cannot marshall id " + String.valueOf(id));
        }
        return id;
    }

    public InsertManyResult insertMany(List<? extends T> documents, InsertManyOptions options) {
        Assert.isTrue(documents != null && !documents.isEmpty(), "documents list cannot be null or empty");
        Assert.notNull(options, "insertMany options cannot be null");
        if (options.getConcurrency() > 1 && options.isOrdered()) {
            throw new IllegalArgumentException("Cannot run ordered insert_many concurrently.");
        }
        if (options.getChunkSize() > this.dataAPIOptions.getMaxDocumentsInInsert()) {
            throw new IllegalArgumentException("Cannot insert more than " + this.dataAPIOptions.getMaxDocumentsInInsert() + " at a time.");
        }
        long start = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(options.getConcurrency());
        ArrayList<Future<InsertManyResult>> futures = new ArrayList<Future<InsertManyResult>>();
        for (int i = 0; i < documents.size(); i += options.getChunkSize()) {
            futures.add(executor.submit(this.getInsertManyResultCallable(documents, options, i)));
        }
        executor.shutdown();
        InsertManyResult finalResult = new InsertManyResult();
        try {
            for (Future future : futures) {
                finalResult.getInsertedIds().addAll(((InsertManyResult)future.get()).getInsertedIds());
            }
            if (!executor.awaitTermination(options.getTimeout(), TimeUnit.MILLISECONDS)) {
                throw new DataApiException("CLIENT_TIMEOUT", "Request did not complete withing ");
            }
            log.debug(AnsiUtils.magenta(".[total insertMany.responseTime]") + "=" + AnsiUtils.yellow("{}") + " millis.", (Object)(System.currentTimeMillis() - start));
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof DataApiException) {
                throw (DataApiException)e.getCause();
            }
            Thread.currentThread().interrupt();
            throw new DataApiException("CLIENT_INTERRUPTED", "Thread was interrupted while waiting", e);
        }
        return finalResult;
    }

    public CompletableFuture<InsertManyResult> insertManyAsync(List<? extends T> documents, InsertManyOptions options) {
        return CompletableFuture.supplyAsync(() -> this.insertMany(documents, options));
    }

    public InsertManyResult insertMany(List<? extends T> documents) {
        return this.insertMany(documents, new InsertManyOptions());
    }

    @SafeVarargs
    public final InsertManyResult insertMany(T ... documents) {
        return this.insertMany(Arrays.asList(documents), new InsertManyOptions());
    }

    public CompletableFuture<InsertManyResult> insertManyAsync(List<? extends T> documents) {
        return CompletableFuture.supplyAsync(() -> this.insertMany(documents));
    }

    private Callable<InsertManyResult> getInsertManyResultCallable(List<? extends T> documents, InsertManyOptions insertManyOptions, int start) {
        int end = Math.min(start + insertManyOptions.getChunkSize(), documents.size());
        return () -> {
            log.debug("Insert block (" + AnsiUtils.cyan("size={}") + ") in collection {}", (Object)(end - start), (Object)AnsiUtils.green(this.getCollectionName()));
            Command insertMany = new Command("insertMany").withDocuments(documents.subList(start, end)).withOptions(new Document().append(INPUT_ORDERED, insertManyOptions.isOrdered()));
            return new InsertManyResult(this.runCommand(insertMany, insertManyOptions).getStatusKeyAsList(RESULT_INSERTED_IDS, Object.class).stream().map(this::unmarshallDocumentId).collect(Collectors.toList()));
        };
    }

    public Optional<T> findOne(Filter filter) {
        return this.findOne(filter, new FindOneOptions());
    }

    public Optional<T> findOne(Filter filter, FindOneOptions findOneOptions) {
        Assert.notNull(findOneOptions, ARG_OPTIONS);
        Command findOne = Command.create("findOne").withFilter(filter).withSort(findOneOptions.getSort()).withProjection(findOneOptions.getProjection()).withOptions(new Document().appendIfNotNull(INPUT_INCLUDE_SIMILARITY, findOneOptions.getIncludeSimilarity()).appendIfNotNull(INPUT_INCLUDE_SORT_VECTOR, findOneOptions.getIncludeSortVector()));
        return Optional.ofNullable(this.runCommand(findOne, findOneOptions).getData().getDocument().map(this.getDocumentClass()));
    }

    public Optional<T> findOne(FindOneOptions findOneOptions) {
        return this.findOne(null, findOneOptions);
    }

    public CompletableFuture<Optional<T>> findOneASync(Filter filter) {
        return CompletableFuture.supplyAsync(() -> this.findOne(filter));
    }

    public CompletableFuture<Optional<T>> findOneASync(Filter filter, FindOneOptions findOneOptions) {
        return CompletableFuture.supplyAsync(() -> this.findOne(filter, findOneOptions));
    }

    public Optional<T> findById(Object id) {
        return this.findOne(Filters.eq(id));
    }

    public FindIterable<T> find(Filter filter, FindOptions options) {
        return new FindIterable(this, filter, options);
    }

    public FindIterable<T> find() {
        return this.find(null, new FindOptions());
    }

    public FindIterable<T> find(Filter filter) {
        return this.find(filter, new FindOptions());
    }

    public FindIterable<T> find(Filter filter, float[] vector, int limit) {
        return this.find(filter, new FindOptions().sort(vector, new Sort[0]).limit(limit));
    }

    public FindIterable<T> find(float[] vector, int limit) {
        return this.find(null, new FindOptions().sort(vector, new Sort[0]).limit(limit));
    }

    public FindIterable<T> find(Filter filter, String vectorize, int limit) {
        return this.find(filter, new FindOptions().sort(vectorize, new Sort[0]).limit(limit));
    }

    public FindIterable<T> find(FindOptions options) {
        return this.find(null, options);
    }

    public Page<T> findPage(Filter filter, FindOptions options) {
        Command findCommand = Command.create("find").withFilter(filter).withSort(options.getSort()).withProjection(options.getProjection()).withOptions(new Document().appendIfNotNull("skip", options.getSkip()).appendIfNotNull("limit", options.getLimit()).appendIfNotNull(INPUT_PAGE_STATE, options.getPageState()).appendIfNotNull(INPUT_INCLUDE_SORT_VECTOR, options.getIncludeSortVector()).appendIfNotNull(INPUT_INCLUDE_SIMILARITY, options.getIncludeSimilarity()));
        ApiResponse apiResponse = this.runCommand(findCommand, options);
        float[] sortVector = null;
        if (options.getIncludeSortVector() != null && apiResponse.getStatus() != null && apiResponse.getStatus().get(DataAPIKeywords.SORT_VECTOR.getKeyword()) != null) {
            sortVector = apiResponse.getStatus().get(DataAPIKeywords.SORT_VECTOR.getKeyword(), float[].class);
        }
        return new Page(apiResponse.getData().getNextPageState(), apiResponse.getData().getDocuments().stream().map(d -> d.map(this.getDocumentClass())).collect(Collectors.toList()), sortVector);
    }

    public CompletableFuture<Page<T>> findPageASync(Filter filter, FindOptions options) {
        return CompletableFuture.supplyAsync(() -> this.findPage(filter, options));
    }

    public <F> DistinctIterable<T, F> distinct(String fieldName, Class<F> resultClass) {
        return this.distinct(fieldName, null, resultClass);
    }

    public <F> DistinctIterable<T, F> distinct(String fieldName, Filter filter, Class<F> resultClass) {
        return new DistinctIterable(this, fieldName, filter, resultClass);
    }

    public int countDocuments(int upperBound) throws TooManyDocumentsToCountException {
        return this.countDocuments(null, upperBound);
    }

    public long estimatedDocumentCount() {
        return this.estimatedDocumentCount(new EstimatedCountDocumentsOptions());
    }

    public long estimatedDocumentCount(EstimatedCountDocumentsOptions options) {
        Command command = new Command("estimatedDocumentCount");
        ApiResponse response = this.runCommand(command, options);
        return response.getStatus().getInteger(RESULT_COUNT).intValue();
    }

    public int countDocuments(Filter filter, int upperBound, CountDocumentsOptions options) throws TooManyDocumentsToCountException {
        if (upperBound < 1 || upperBound > this.dataAPIOptions.getMaxDocumentCount()) {
            throw new IllegalArgumentException("UpperBound limit should be in between 1 and " + this.dataAPIOptions.getMaxDocumentCount());
        }
        Command command = new Command("countDocuments").withFilter(filter);
        ApiResponse response = this.runCommand(command, options);
        Boolean moreData = response.getStatus().getBoolean(RESULT_MORE_DATA);
        Integer count = response.getStatus().getInteger(RESULT_COUNT);
        if (moreData != null && moreData.booleanValue()) {
            throw new TooManyDocumentsToCountException();
        }
        if (count > upperBound) {
            throw new TooManyDocumentsToCountException(upperBound);
        }
        return count;
    }

    public int countDocuments(Filter filter, int upperBound) throws TooManyDocumentsToCountException {
        return this.countDocuments(filter, upperBound, new CountDocumentsOptions());
    }

    public DeleteResult deleteOne(Filter filter) {
        return this.deleteOne(filter, new DeleteOneOptions());
    }

    public DeleteResult deleteOne(Filter filter, DeleteOneOptions deleteOneOptions) {
        Command deleteOne = Command.create("deleteOne").withFilter(filter).withSort(deleteOneOptions.getSort());
        ApiResponse apiResponse = this.runCommand(deleteOne, deleteOneOptions);
        int deletedCount = apiResponse.getStatus().getInteger(RESULT_DELETED_COUNT);
        return new DeleteResult(deletedCount);
    }

    public DeleteResult deleteMany(Filter filter, DeleteManyOptions options) {
        AtomicInteger totalCount = new AtomicInteger(0);
        boolean moreData = false;
        do {
            Command deleteMany;
            ApiResponse apiResponse;
            Document status;
            if ((status = (apiResponse = this.runCommand(deleteMany = Command.create("deleteMany").withFilter(filter), options)).getStatus()) == null) continue;
            if (status.containsKey(RESULT_DELETED_COUNT)) {
                totalCount.addAndGet(status.getInteger(RESULT_DELETED_COUNT));
            }
            moreData = status.containsKey(RESULT_MORE_DATA);
        } while (moreData);
        return new DeleteResult(totalCount.get());
    }

    public DeleteResult deleteMany(Filter filter) {
        return this.deleteMany(filter, new DeleteManyOptions());
    }

    public DeleteResult deleteAll() {
        return this.deleteMany(new Filter());
    }

    public boolean exists() {
        return this.getDatabase().collectionExists(this.getName());
    }

    public void drop() {
        this.getDatabase().dropCollection(this.collectionName);
    }

    public Optional<T> findOneAndReplace(Filter filter, T replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    public Optional<T> findOneAndReplace(Filter filter, T replacement, FindOneAndReplaceOptions options) {
        Command findOneAndReplace = Command.create("findOneAndReplace").withFilter(filter).withReplacement(replacement).withSort(options.getSort()).withProjection(options.getProjection()).withOptions(new Document().appendIfNotNull(INPUT_UPSERT, options.getUpsert()).appendIfNotNull(INPUT_RETURN_DOCUMENT, options.getReturnDocument()));
        ApiResponse res = this.runCommand(findOneAndReplace, options);
        if (res.getData() != null && res.getData().getDocument() != null) {
            return Optional.ofNullable(res.getData().getDocument().map(this.getDocumentClass()));
        }
        return Optional.empty();
    }

    public UpdateResult replaceOne(Filter filter, T replacement) {
        return this.replaceOne(filter, replacement, new ReplaceOneOptions());
    }

    public UpdateResult replaceOne(Filter filter, T replacement, ReplaceOneOptions replaceOneOptions) {
        Document doc;
        Command findOneAndReplace = Command.create("findOneAndReplace").withFilter(filter).withReplacement(replacement).withOptions(new Document().appendIfNotNull(INPUT_UPSERT, replaceOneOptions.getUpsert()).append(INPUT_RETURN_DOCUMENT, ReturnDocument.BEFORE.getKey()));
        FindOneAndReplaceResult<T> res = this.executeFindOneAndReplace(findOneAndReplace, replaceOneOptions);
        UpdateResult result = new UpdateResult();
        result.setMatchedCount(res.getMatchedCount());
        result.setModifiedCount(res.getModifiedCount());
        if (res.getDocument() != null && (doc = JsonUtils.convertValue(res.getDocument(), Document.class)).getId(Object.class) != null) {
            result.setUpsertedId(doc.getId(Object.class));
        }
        return result;
    }

    private FindOneAndReplaceResult<T> executeFindOneAndReplace(Command cmd, CommandOptions options) {
        Document status;
        ApiResponse apiResponse = this.runCommand(cmd, options);
        FindOneAndReplaceResult<T> result = new FindOneAndReplaceResult<T>();
        if (apiResponse.getData() == null) {
            throw new DataAPIFaultyResponseException(cmd, apiResponse, "Faulty response from find_one_and_replace API command.");
        }
        if (apiResponse.getData().getDocument() != null) {
            result.setDocument(apiResponse.getData().getDocument().map(this.getDocumentClass()));
        }
        if ((status = apiResponse.getStatus()) != null) {
            if (status.containsKey(RESULT_MATCHED_COUNT)) {
                result.setMatchedCount(status.getInteger(RESULT_MATCHED_COUNT));
            }
            if (status.containsKey(RESULT_MODIFIED_COUNT)) {
                result.setModifiedCount(status.getInteger(RESULT_MODIFIED_COUNT));
            }
        }
        return result;
    }

    public Optional<T> findOneAndUpdate(Filter filter, Update update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    public Optional<T> findOneAndUpdate(Filter filter, Update update, FindOneAndUpdateOptions options) {
        Assert.notNull(update, ARG_UPDATE);
        Assert.notNull(options, ARG_OPTIONS);
        Command cmd = Command.create("findOneAndUpdate").withFilter(filter).withUpdate(update).withSort(options.getSort()).withProjection(options.getProjection()).withOptions(new Document().appendIfNotNull(INPUT_UPSERT, options.getUpsert()).append(INPUT_RETURN_DOCUMENT, options.getReturnDocument()));
        ApiResponse res = this.runCommand(cmd, options);
        if (res.getData() != null && res.getData().getDocument() != null) {
            return Optional.ofNullable(res.getData().getDocument().map(this.getDocumentClass()));
        }
        return Optional.empty();
    }

    public UpdateResult updateOne(Filter filter, Update update) {
        return this.updateOne(filter, update, new UpdateOneOptions());
    }

    public UpdateResult updateOne(Filter filter, Update update, UpdateOneOptions updateOptions) {
        Assert.notNull(update, ARG_UPDATE);
        Assert.notNull(updateOptions, ARG_OPTIONS);
        Command cmd = Command.create("updateOne").withFilter(filter).withUpdate(update).withSort(updateOptions.getSort()).withOptions(new Document().appendIfNotNull(INPUT_UPSERT, updateOptions.getUpsert()));
        return Collection.getUpdateResult(this.runCommand(cmd, updateOptions));
    }

    private static UpdateResult getUpdateResult(ApiResponse apiResponse) {
        UpdateResult result = new UpdateResult();
        Document status = apiResponse.getStatus();
        if (status != null) {
            if (status.containsKey(RESULT_MATCHED_COUNT)) {
                result.setMatchedCount(status.getInteger(RESULT_MATCHED_COUNT));
            }
            if (status.containsKey(RESULT_MODIFIED_COUNT)) {
                result.setModifiedCount(status.getInteger(RESULT_MODIFIED_COUNT));
            }
            if (status.containsKey(RESULT_UPSERTED_ID)) {
                result.setMatchedCount(status.getInteger(RESULT_UPSERTED_ID));
            }
        }
        return result;
    }

    public UpdateResult updateMany(Filter filter, Update update) {
        return this.updateMany(filter, update, new UpdateManyOptions());
    }

    public UpdateResult updateMany(Filter filter, Update update, UpdateManyOptions options) {
        Assert.notNull(update, ARG_UPDATE);
        Assert.notNull(options, ARG_OPTIONS);
        String nextPageState = null;
        UpdateResult result = new UpdateResult();
        result.setMatchedCount(0);
        result.setModifiedCount(0);
        do {
            Document status;
            Command cmd;
            ApiResponse res;
            if ((res = this.runCommand(cmd = Command.create("updateMany").withFilter(filter).withUpdate(update).withOptions(new Document().appendIfNotNull(INPUT_UPSERT, options.getUpsert()).appendIfNotNull(INPUT_PAGE_STATE, nextPageState)), options)).getData() != null) {
                nextPageState = res.getData().getNextPageState();
            }
            if ((status = res.getStatus()).containsKey(RESULT_MATCHED_COUNT)) {
                result.setMatchedCount(result.getMatchedCount() + status.getInteger(RESULT_MATCHED_COUNT));
            }
            if (status.containsKey(RESULT_MODIFIED_COUNT)) {
                result.setModifiedCount(result.getModifiedCount() + status.getInteger(RESULT_MODIFIED_COUNT));
            }
            if (!status.containsKey(RESULT_UPSERTED_ID)) continue;
            result.setUpsertedId(status.getInteger(RESULT_UPSERTED_ID));
        } while (nextPageState != null);
        return result;
    }

    public Optional<T> findOneAndDelete(Filter filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    public CompletableFuture<Optional<T>> findOneAndDeleteAsync(Filter filter) {
        return CompletableFuture.supplyAsync(() -> this.findOneAndDelete(filter));
    }

    public Optional<T> findOneAndDelete(Filter filter, FindOneAndDeleteOptions options) {
        Command findOneAndReplace = Command.create("findOneAndDelete").withFilter(filter).withSort(options.getSort()).withProjection(options.getProjection());
        ApiResponse res = this.runCommand(findOneAndReplace, options);
        if (res.getData() != null && res.getData().getDocument() != null) {
            return Optional.ofNullable(res.getData().getDocument().map(this.getDocumentClass()));
        }
        return Optional.empty();
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public BulkWriteResult bulkWrite(List<Command> commands) {
        return this.bulkWrite(commands, new BulkWriteOptions());
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public BulkWriteResult bulkWrite(List<Command> commands, BulkWriteOptions options) {
        Assert.notNull(commands, ARG_COMMANDS);
        Assert.notNull(options, ARG_OPTIONS);
        if (options.getConcurrency() > 1 && options.isOrdered()) {
            throw new IllegalArgumentException("Cannot run ordered bulk_write concurrently.");
        }
        BulkWriteResult result = new BulkWriteResult(commands.size());
        if (options.isOrdered()) {
            result.setResponses(commands.stream().map(cmd -> this.runCommand((Command)cmd, options)).collect(Collectors.toList()));
        } else {
            try {
                ExecutorService executor = Executors.newFixedThreadPool(options.getConcurrency());
                ArrayList futures = new ArrayList();
                commands.forEach(req -> futures.add(executor.submit(() -> this.runCommand((Command)req, options))));
                executor.shutdown();
                for (Future future : futures) {
                    result.getResponses().add((ApiResponse)future.get());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread was interrupted while waiting for command results", e);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Cannot access command results", e);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error occurred during command execution", e.getCause());
            }
        }
        return result;
    }

    @Deprecated
    public void registerListener(String logger, CommandObserver commandObserver) {
        this.commandOptions.registerObserver(logger, commandObserver);
    }

    @Deprecated
    public void deleteListener(String name) {
        this.commandOptions.unregisterObserver(name);
    }

    @Override
    protected String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Class<T> getDocumentClass() {
        return this.documentClass;
    }

    public Database getDatabase() {
        return this.database;
    }

    public DataAPIOptions getDataAPIOptions() {
        return this.dataAPIOptions;
    }
}

