/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.astra.client;

import com.datastax.astra.client.DataAPIOptions;
import com.datastax.astra.client.Database;
import com.datastax.astra.client.admin.AstraDBAdmin;
import com.datastax.astra.internal.api.AstraApiEndpoint;
import com.datastax.astra.internal.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import java.util.Optional;
import java.util.UUID;

public class DataAPIClient {
    private static final String ARG_NAMESPACE = "namespace";
    private static final String ARG_OPTIONS = "options";
    private static final String ARG_TOKEN = "token";
    private static final String ARG_DATABASE_ID = "databaseId";
    private static final String ARG_REGION = "region";
    private final String token;
    private final DataAPIOptions options;

    public DataAPIClient(String token) {
        this(token, DataAPIOptions.builder().build());
    }

    public DataAPIClient(String token, DataAPIOptions options) {
        Assert.hasLength(token, ARG_TOKEN);
        Assert.notNull(options, ARG_OPTIONS);
        this.token = token;
        this.options = options;
    }

    public AstraDBAdmin getAdmin() {
        return this.getAdmin(this.token);
    }

    public AstraDBAdmin getAdmin(String superUserToken) {
        return new AstraDBAdmin(superUserToken, this.getAstraEnvironment(), this.options);
    }

    private Optional<AstraEnvironment> findAstraEnvironment() {
        if (this.options.getDestination() != null) {
            switch (this.options.getDestination()) {
                case ASTRA: {
                    return Optional.of(AstraEnvironment.PROD);
                }
                case ASTRA_DEV: {
                    return Optional.of(AstraEnvironment.DEV);
                }
                case ASTRA_TEST: {
                    return Optional.of(AstraEnvironment.TEST);
                }
            }
        }
        return Optional.empty();
    }

    private AstraEnvironment getAstraEnvironment() {
        return this.findAstraEnvironment().orElseThrow(() -> new IllegalArgumentException("'destination' should be ASTRA* to use the AstraDBAdmin"));
    }

    public Database getDatabase(UUID databaseId, String namespace) {
        Assert.notNull(databaseId, ARG_DATABASE_ID);
        Assert.hasLength(namespace, ARG_NAMESPACE);
        return new Database(new AstraApiEndpoint(databaseId, this.getAdmin().getDatabaseInfo(databaseId).getRegion(), this.getAstraEnvironment()).getApiEndPoint(), this.token, namespace, this.options);
    }

    public Database getDatabase(UUID databaseId, String namespace, String region) {
        Assert.notNull(databaseId, ARG_DATABASE_ID);
        Assert.hasLength(namespace, ARG_NAMESPACE);
        Assert.hasLength(region, ARG_REGION);
        return new Database(new AstraApiEndpoint(databaseId, region, this.getAstraEnvironment()).getApiEndPoint(), this.token, namespace, this.options);
    }

    public Database getDatabase(UUID databaseId) {
        return this.getDatabase(databaseId, "default_keyspace");
    }

    public Database getDatabase(String apiEndpoint, String namespace) {
        return new Database(apiEndpoint, this.token, namespace, this.options);
    }

    public Database getDatabase(String apiEndpoint) {
        return this.getDatabase(apiEndpoint, "default_keyspace");
    }
}

